﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using RPCSupport;
using RPCSupport.Devices;

namespace HealthSensorPlatform
{
    class RegisterField : IRegisterFieldView
    {
        /// <summary>
        /// Device which is connected to this RegisterField
        /// </summary>
        public IRegisterDevice Device;
        /// <summary>
        /// Bit name in data sheet
        /// </summary>
        public string Name;
        /// <summary>
        /// Register number
        /// </summary>
        public int Register;
        /// <summary>
        /// LSB Bit index number of bit field
        /// </summary>
        public int Index; 
        /// <summary>
        /// Length of bit field
        /// </summary>
        public int Width;
        /// <summary>
        /// Description array of field settings
        /// </summary>
        public string[] Descriptions;
        /// <summary>
        /// Control associated with bit field
        /// </summary>
        Control control;
        public Control Control
        {
            get
            {
                return control;
            }
            set
            {
                control = value;
                if (control.GetType() == typeof(MaximStyle.MaximComboBox))
                {
                    MaximStyle.MaximComboBox cb = (MaximStyle.MaximComboBox)control;
                    cb.Items.Clear();
                    foreach (string s in Descriptions)
                    {
                        cb.Items.Add(s);
                    }
                }
            }
        }

        /// <summary>
        /// Label (Text) associated with register field
        /// </summary>
        Label label;
        public Label Label
        { 
            set
            {
                LabelDescription = value.Text;
                label = value;
            }

            get
            {
                return label;
            }
        }

        /// <summary>
        /// Text value of label
        /// </summary>
        public string LabelDescription;

        /// <summary>
        /// Automatically update register field 
        /// </summary>
        public bool AutoUpdate = true;

        /// <summary>
        /// Read register field value
        /// </summary>
        /// <returns></returns>
        public int ReadField()
        {
            int registerData;

            registerData = Device.ReadReg((byte)Register);

            return (registerData >> Index) & ((1 << Width) - 1);
        }
        
        /// <summary>
        /// Write register field value
        /// </summary>
        /// <param name="data">value to write to field</param>
        public void WriteField(int data)
        {
            int registerData;

            registerData = Device.ReadReg((byte)Register);
            registerData &= ~(((1 << Width) - 1) << Index); // Mask and Clear Bits
            registerData |= data << Index; // Set Bits 

            Device.WriteReg((byte)Register, registerData);
        }

    }
}
