﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HealthSensorPlatform.CustomControls
{
    public partial class RegisterExportView : UserControl
    {
        /* Constructors */
        public RegisterExportView()
        {
            InitializeComponent();
        }

        /* Properties */
        public ListBox.ObjectCollection ItemsLeft
        {
            get
            {
                return listViewLeft.Items;
            }
        }
        public ListBox.ObjectCollection ItemsRight
        {
            get
            {
                return listViewRight.Items;
            }
        }

        /* Events */
        public event EventHandler<RegisterExportEventArgs> Complete;

        /* Methods */
        private void btnExport_Click(object sender, EventArgs e)
        {
            if (Complete != null)
                Complete(this, new RegisterExportEventArgs() { Button = Button.Export });
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            if (Complete != null)
                Complete(this, new RegisterExportEventArgs() { Button = Button.Cancel });
        }

        private void btnRight_Click(object sender, EventArgs e)
        {
            if (listViewLeft.SelectedItem != null)
            {
                listViewRight.Items.Add(listViewLeft.SelectedItem);
                listViewLeft.Items.Remove(listViewLeft.SelectedItem);
            }
        }

        private void btnLeft_Click(object sender, EventArgs e)
        {
            if (listViewRight.SelectedItem != null)
            {
                listViewLeft.Items.Add(listViewRight.SelectedItem);
                listViewRight.Items.Remove(listViewRight.SelectedItem);
            }
        }

        /* Enum */
        public enum Button
        {
            Export,
            Cancel
        }

    }

    public class RegisterExportEventArgs : EventArgs
    {
        public RegisterExportView.Button Button;
    }

}
