/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using Microsoft.Win32.SafeHandles; 
using System.Runtime.InteropServices;
//using System.Threading;

//----------------------------------------------------------------------
// MSVC reports Warning: XML comment is not placed on a valid language element.
// MSVC does not support attaching documentation to namespaces.
// But doxygen does, so this isn't an issue.
//----------------------------------------------------------------------
// warning CS1587: XML comment is not placed on a valid language element
#pragma warning disable 1587
///  <summary>
/// @file FileIODeclarations.cs
/// @brief API declarations relating to file I/O.
/// 
/// 
///  </summary>
//----------------------------------------------------------------------
#pragma warning restore 1587

//------------------------------------------------------------------------------------------
// OS24EVK-59 split into HeartRateApp EXE and MAX30101 DLL.
// Moved all MAX30101 DLL classes into namespace Maxim.MAX30101GUI
// Moved all HeartRateApp GUI classes into namespace Maxim.MAX30101
// OS24EVK-59 Create separate project that builds Maxim.MAX30101GUI DLL library

// OS24EVK-59 moved class FileIO into namespace Maxim.MAX30101 instead of namespace HeartRateApp
namespace RPCSupport
{   
    internal sealed class FileIO 
    {
        internal const Int32 FILE_FLAG_OVERLAPPED = 0X40000000; 
        internal const Int32 FILE_SHARE_READ = 1; 
        internal const Int32 FILE_SHARE_WRITE = 2; 
        internal const UInt32 GENERIC_READ = 0X80000000; 
        internal const UInt32 GENERIC_WRITE = 0X40000000; 
        internal const Int32 INVALID_HANDLE_VALUE = -1; 
        internal const Int32 OPEN_EXISTING = 3; 
        internal const Int32 WAIT_TIMEOUT = 0X102;
		internal const Int32 WAIT_OBJECT_0 = 0;         
    
        [ StructLayout( LayoutKind.Sequential ) ]
        internal class SECURITY_ATTRIBUTES  
        { 
            internal Int32 nLength; 
            internal Int32 lpSecurityDescriptor; 
            internal Int32 bInheritHandle; 
        }    
        
        [ DllImport( "kernel32.dll", SetLastError=true ) ]
		internal static extern bool CancelIo(SafeFileHandle hFile);        
        
        [ DllImport( "kernel32.dll", CharSet=CharSet.Auto, SetLastError=true ) ]
        internal static extern IntPtr CreateEvent(IntPtr SecurityAttributes, Boolean bManualReset, Boolean bInitialState, String lpName);
       
        [ DllImport( "kernel32.dll", CharSet=CharSet.Auto, SetLastError=true ) ]
        internal static extern SafeFileHandle CreateFile(String lpFileName, UInt32 dwDesiredAccess, Int32 dwShareMode, IntPtr lpSecurityAttributes, Int32 dwCreationDisposition, Int32 dwFlagsAndAttributes, Int32 hTemplateFile);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        internal static extern int FormatMessage (Int32 dwFlags, Int32 lpSource, Int32 dwMessageId, Int32 dwLanguageZId, string lpBuffer, Int32 nSize, Int32 Arguments);
    
		[DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		internal static extern bool GetOverlappedResult(SafeFileHandle hFile, IntPtr lpOverlapped, ref Int32 lpNumberOfBytesTransferred, Boolean bWait);       

        [ DllImport( "kernel32.dll", SetLastError=true ) ]
        internal static extern bool ReadFile(SafeFileHandle hFile, IntPtr lpBuffer, Int32 nNumberOfBytesToRead, ref Int32 lpNumberOfBytesRead, IntPtr lpOverlapped);

        [DllImport("kernel32.dll", SetLastError = true)]
        internal static extern void Sleep(UInt32 dwMilliseconds);

        [ DllImport( "kernel32.dll", SetLastError=true ) ]
        internal static extern Int32 WaitForSingleObject(IntPtr hHandle, Int32 dwMilliseconds);        
       
        [ DllImport( "kernel32.dll", SetLastError=true ) ]
        internal static extern bool WriteFile(SafeFileHandle hFile, IntPtr lpBuffer, Int32 nNumberOfBytesToWrite, ref Int32 lpNumberOfBytesWritten, IntPtr lpOverlapped);
    }     
} 
