﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform
{

    public partial class HspForm
    {
        List<RegisterField> paceChannelField = new List<RegisterField>();

        void initalizePaceChannelFields()
        {
            // Pace Channel
            string[] aoutLbwOptions = { "Max (~100 kHz)*", "Limited (16 kHz)" };
            string[] aoutOptions = { "Disabled*", "INA Output", "PGA Output", "Pace Input" };
            string[] polOptions = { "Non-Inverted*", "Inverted" };
            string[] gainOptions = { "540   / 50.625 / 202.50*", 
                                     "270   / 50.625 / 101.25", 
                                     "240   / 22.5     /  90", 
                                     "120   / 22.5     /  45", 
                                     " 60    /  5.625  /  22.5", 
                                     " 30    /  5.625  /  11.25", 
                                     " 26.4 /  5.625 /  22.5", 
                                     " 13.2 /  5.625 /  11.25" 
                                   };
            string[] gnDiffOffOptions = { "Differentiator*", "Sample and Hold" };
            string[] dacpOptions = new string[16];
            for (int i = 0; i < dacpOptions.Length; i++)
            {
                dacpOptions[i] = (22.5 * i).ToString() + " mV";
            }
            dacpOptions[5] += "*";
            string[] dacnOptions = new string[16];
            for (int i = 0; i < dacnOptions.Length; i++)
            {
                dacnOptions[i] = (-22.5 * i).ToString() + " mV";
            }
            dacnOptions[5] += "*";

            //RegisterField rateField = new RegisterField { Name = "BIOZ_RATE", Register = 0x18, Index = 23, Width = 1, Descriptions = rateOptions, Label = lblBioZSampleRate, Control = cboBioZSampleRate };
            RegisterField polField = new RegisterField { Name = "PACE_POL", Register = 0x1A, Index = 23, Width = 1, Descriptions = polOptions, Label = lblPaceInputPolarity, Control = cboPaceInputPolarity, Device = max30001 };
            RegisterField gnDiffOffField = new RegisterField { Name = "PACE_GN_DIFF_OFF", Register = 0x1A, Index = 19, Width = 1, Descriptions = gnDiffOffOptions, Label = lblPaceDifferentiatorMode, Control = cboPaceDifferentiatorMode, Device = max30001 };
            RegisterField gainField = new RegisterField { Name = "PACE_GAIN", Register = 0x1A, Index = 16, Width = 3, Descriptions = gainOptions, Label = lblPaceChannelGain, Control = cboPaceChannelGain, Device = max30001 };
            RegisterField aoutLbwField = new RegisterField { Name = "PACE_AOUT_LBW", Register = 0x1A, Index = 14, Width = 1, Descriptions = aoutLbwOptions, Label = lblPaceBufferBandwidth, Control = cboPaceBufferBandwidth, Device = max30001 };
            RegisterField aoutField = new RegisterField { Name = "PACE_AOUT", Register = 0x1A, Index = 12, Width = 2, Descriptions = aoutOptions, Label = lblPaceSignalSelection, Control = cboPaceSignalSelection, Device = max30001 };
            RegisterField dacpField = new RegisterField { Name = "PACE_DACP", Register = 0x1A, Index = 4, Width = 4, Descriptions = dacpOptions, Label = lblPaceDetectorPostiveThreshold, Control = cboPaceDetectorPostiveThreshold, Device = max30001 };
            RegisterField dacnField = new RegisterField { Name = "PACE_DACN", Register = 0x1A, Index = 0, Width = 4, Descriptions = dacnOptions, Label = lblPaceDetectorNegativeThreshold, Control = cboPaceDetectorNegativeThreshold, Device = max30001 };
            paceChannelField.Add(polField);
            paceChannelField.Add(gnDiffOffField);
            paceChannelField.Add(gainField);
            paceChannelField.Add(aoutLbwField);
            paceChannelField.Add(aoutField);
            paceChannelField.Add(dacpField);
            paceChannelField.Add(dacnField);

            // BioZ Channel
            string[] aHpfOptions = { "250 Hz", "500 Hz", "1000 Hz*", "2000 Hz", "4000 Hz", "8000 Hz", "Bypass" };
            RegisterField aHpfField = new RegisterField { Name = "BIOZ_AHPF", Register = 0x18, Index = 20, Width = 3, Descriptions = aHpfOptions, Label = lblPaceAnalogHpf, Control = cboPaceAnalogHpf, Device = max30001 };
            paceChannelField.Add(aHpfField);
        }

        void PaceChannelUpdateRegisters()
        {
            internalUpdate = true;
            ReadComboBoxesRegisters(paceChannelField);
            internalUpdate = false;
        }

        private CustomControls.InitArgs.PACEInitStart getPaceArgs()
        {
            CustomControls.InitArgs.PACEInitStart paceArgs = new CustomControls.InitArgs.PACEInitStart();

            paceArgs.En_pace = chkEnPace.Checked == true ? 1 : 0;
            paceArgs.Clr_pedge = 0; // TODO default from jerry
            paceArgs.Pol = cboPaceInputPolarity.SelectedIndex;
            paceArgs.Gn_diff_off = cboPaceDifferentiatorMode.SelectedIndex;
            paceArgs.Gain = cboPaceChannelGain.SelectedIndex;
            paceArgs.Aout_lbw = cboPaceBufferBandwidth.SelectedIndex;
            paceArgs.Aout = cboPaceSignalSelection.SelectedIndex;
            paceArgs.Dacp = cboPaceDetectorPostiveThreshold.SelectedIndex;
            paceArgs.Dacn = cboPaceDetectorNegativeThreshold.SelectedIndex;

            return paceArgs;
        }

        private void setPaceArgs(CustomControls.InitArgs.PACEInitStart paceArgs)
        {
            //paceArgs.En_pace = chkEnPace.Checked == true ? 1 : 0;
            //paceArgs.Clr_pedge = 0; // TODO default from jerry
            cboPaceInputPolarity.SelectedIndex = paceArgs.Pol;
            cboPaceDifferentiatorMode.SelectedIndex = paceArgs.Gn_diff_off;
            cboPaceChannelGain.SelectedIndex = paceArgs.Gain;
            cboPaceBufferBandwidth.SelectedIndex = paceArgs.Aout_lbw;
            cboPaceSignalSelection.SelectedIndex = paceArgs.Aout;
            cboPaceDetectorPostiveThreshold.SelectedIndex = paceArgs.Dacp;
            cboPaceDetectorNegativeThreshold.SelectedIndex = paceArgs.Dacn;
        }
    }
}
