﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HealthSensorPlatform.DeviceDescriptions;
using RPCSupport.DeviceSupport;

namespace Maxim.CustomControls
{
    /// <summary>
    /// PMIC Register Information
    /// </summary>
    public class MAX14720Info : Device
    {

        public MAX14720Info()
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.InitI2c(2, 0x54);

            initalizeDescription();

        }

        void initalizeDescription()
        {
            Info = new RegisterInfo[] {
                new RegisterInfo("ChipId",0x00),
                new RegisterInfo("ChipRev",0x01),
                new RegisterInfo("BoostCDiv",0x03),
                new RegisterInfo("BoostISet",0x04),
                new RegisterInfo("BoostVSet",0x05),
                new RegisterInfo("BoostCfg",0x06),
                new RegisterInfo("BuckVSet",0x07),
                new RegisterInfo("BuckCfg",0x08),
                new RegisterInfo("BuckISet",0x09),
                new RegisterInfo("LDOVSet",0x0A),
                new RegisterInfo("LDOCfg",0x0B),
                new RegisterInfo("SwitchCfg",0x0C),
                new RegisterInfo("BatTime",0x0D),
                new RegisterInfo("BatCfg",0x0E),
                new RegisterInfo("BatBCV",0x0F),
                new RegisterInfo("BatOCV",0x10),
                new RegisterInfo("BattLCV",0x11),
                new RegisterInfo("MONCfg",0x19),
                new RegisterInfo("BoostCfg",0x1A),
                new RegisterInfo("PinStat",0x1B),
                new RegisterInfo("BBBExtra",0x1C),
                new RegisterInfo("HandShk",0x1D),
                new RegisterInfo("UVLOCfg",0x1E),
                new RegisterInfo("PWROFF",0x1F)
           };

            // register 0x00
            Descriptions(0x00).Add("Bit [7:0]", "ChipId", "Version information");
            // register 0x01
            Descriptions(0x01).Add("Bit [7:0]", "ChipRev", "Revison Information");
            // register 0x03
            Descriptions(0x03).Add("Bit 7", "ClkDivEn", @"Boost Current-Limited Output Mode Enable
This allows the boost regulator to be operated in a current limited output mode.
0: Normal Operation, Full Output Current Capability
1: Divided Clock Current Limited Mode
When the clock divider is enabled, the boost is operated with a fixed peak current limit and programmable
frequency. The peak current is set by BoostISet[2:0] and the switching frequency is determined by
ClkDivSet[6:0]. The regulator will stop switching when the voltage is above the set point and will only run when
the voltage is below the output setting. This mode can only be enabled once the output voltage is set higher
than the input voltage.");
            // register 0x03
            Descriptions(0x03).Add("Bit [6:0]", "ClkDivSet", @"Current-Limited Boost Clock Divider Setting
When the current limited mode is enabled, the frequency of the boost regulator in current limited mode will be
the frequency of the oscillator divided by the value of (10 + ClkDivSet[6:0]). The range is fOSC/10 to fOSC/137.");
            // register 0x04
            Descriptions(0x04).Add("Bit [2:0]", "BoostISet", @"Buck-Boost Peak Current-Limit Setting
000: 0 (Minimum On-Time)
001: 50mA
010: 100mA
011: 150mA
100: 200mA
101: 250mA
110: 300mA
111: 350mA");
            // register 0x05
            Descriptions(0x05).Add("Bit [4:0]", "BoostVSet[4:0]", @"Boost Output Voltage Setting. This setting is internally latched and can change only when boost is disabled.
2.5V to 5.0V, linear scale, 100mV increments
000000 = 2.5V
000001 = 2.6V
…
011001 = 5.0V
> 011001 = 5.0V");
            // register 0x06
            Descriptions(0x06).Add("Bit [7:5]", "BoostSeq[2:0]", @"Boost Enable Configuration (Read-Only)
000 = Disabled
001 = Reserved
010 = Enabled at 0% of Boot/POR Process Delay Control
011 = Enabled at 25% of Boot/POR Process Delay Control
100 = Enabled at 50% of Boot/POR Process Delay Control
101 = Reserved
110 = Controlled by HVEN (MAX14750)
111 = Controlled by BoostEn [1:0] after 100% of Boot/POR Process Delay Control (MAX14720)");
            Descriptions(0x06).Add("Bit [4:3]", "BoostEn[1:0]", @"Boost Enable Configuration (effective only when BoostSeq[2:0] == 111)
00 = Disabled. Active discharge behavior depends on BoostActDsc.
01 = Enabled
10 = Enabled when MPC is high
11 = Reserved");
            Descriptions(0x07).Add("Bit 1", "BoostEMI", @"Boost EMI reduction. Dampens ringing of the inductor when in discontinuous mode
0 = EMI damping active (improve EMI)
1 = EMI damping disabled (improve Efficiency)");
            Descriptions(0x08).Add("Bit 0", "BoostInd", @"Boost Inductance Select
1 = Inductance is 3.3µH
0 = Inductance is 4.7µH");
            // register 0x07
            Descriptions(0x07).Add("Bit [5:0]", "BuckVSet[5:0]", @"Buck Output Voltage Setting This setting is internally latched and can change only when buck is disabled.
1.0V to 2.0V, linear scale, 25mV increments
000000 = 1.000V
000001 = 1.025V
…
101000 = 2.0V
> 101000 = 2.0V");
            // register 0x08
            Descriptions(0x08).Add("Bit [7:6]", "BuckSeq[2:0]", @"Buck Enable Configuration (Read-Only)
000 = Disabled
001 = Reserved
010 = Enabled at 0% of Boot/POR Process Delay Control
011 = Enabled at 25% of Boot/POR Process Delay Control
100 = Enabled at 50% of Boot/POR Process Delay Control
101 = Reserved
110 = Controlled by BEN (MAX14750)
111 = Controlled by BuckEn [1:0] after 100% of Boot/POR Process Delay Control");
            Descriptions(0x08).Add("Bit [4:3]", "BuckEn[1:0]", @"Buck Enable Configuration (effective only when BuckSeq[2:0] == 111)
00 = Disabled. Active discharge behavior depends on BuckActDsc.
01 = Enabled
10 = Enabled when MPC is high
11 = Reserved");
            Descriptions(0x08).Add("Bit [2:1]", "BuckMd[1:0]", @"Buck Mode Select
00 = Burst mode
01 = Forced PWM mode
10 = Forced PWM mode when MPC is high
11 = Reserved");
            Descriptions(0x08).Add("Bit 0", "BuckFst", @"Buck Fast Start
0 = Normal startup current limit
1 = Double the startup current to reduce the startup time by half");
            // register 0x09
            Descriptions(0x09).Add("Bit [7:5]", "BuckISet[2:0]", @"Buck Peak Current Limit Setting
000: 50mA
001: 100mA
010: 150mA
011: 200mA
100: 250mA
101: 300mA
110: 350mA
111: 400mA");
            Descriptions(0x09).Add("Bit 4", "BuckCfg", @"Buck Configuration
0 = set to 0 for burst mode
1 = set to 1 for FPWM mode");
            Descriptions(0x09).Add("Bit 3", "BuckInd", @"Buck Inductance Select
0 = Inductance is 2.2µH
1 = Inductance is 4.7µH");
            Descriptions(0x09).Add("Bit 2", "BuckHysOff", @"Buck Hysteresis Off
0 = Enable comparator hysteresis
1 = Disable comparator hysteresis (recommended to reduce voltage ripple)");
            Descriptions(0x09).Add("Bit 1", "BuckMinOT", @"Buck Minimum On-Time
0 = Enable deglitch delay on comparator for better efficiency
1 = Disable deglitch delay on comparator to minimize voltage ripple");
            Descriptions(0x09).Add("Bit 0", "BuckInteg", @"Buck Integrate
0 = Helps stabilize the buck regulator for high currents with small output capacitor
1 = Better load regulation at high current (recommended for output capacitance > 6µF)");
            // register 0x0a
            Descriptions(0x0A).Add("Bit [4:0]", "LDOVSet[4:0]", @"LDO Output Voltage Setting
0.9V to 4V, linear scale, 100mV increments
00000 = 0.9V
00001 = 1.0V
…
10000 = 2.5V
…
11111 = 4.0V");
            // register 0x0b
            Descriptions(0x0B).Add("Bit [7:5]", "LDOSeq[2:0]", @"LDO Enable Configuration (Read-Only)
000 = Disabled
001 = Enabled always when BAT/SYS is present
010 = Enabled at 0% of Boot/POR Process Delay Control
011 = Enabled at 25% of Boot/POR Process Delay Control
100 = Enabled at 50% of Boot/POR Process Delay Control
101 = Disabled
110 = Controlled by LEN (MAX14750)
111 = Controlled by LDOEn[1:0] after 100% of Boot/POR Process Delay Control");
            Descriptions(0x0B).Add("Bit 4", "LDOActDsc", @"LDO Active Discharge Control
0: LDO output will be discharged only entering off and hard-reset modes.
1: LDO output will be discharged only entering off and hard-reset modes and when the enable is low.");
            Descriptions(0x0B).Add("Bit 3", "LDOActDsc", @"LDO Active Discharge Control
0: LDO output will be actively discharged only entering off and hard-reset modes.
1: LDO output will be actively discharged only entering off and hard-reset modes and when the enable is low.");
            Descriptions(0x0B).Add("Bit [2:1]", "LDOEn[1:0]", @"LDO Enable Configuration (effective only when LDOSeq[2:0] == 111)
00 = Disabled
01 = Enabled
10 = Enabled when MPC is high
11 = Reserved");
            Descriptions(0x0B).Add("Bit 0", "LDOMode", @"LDO Mode Control
0 = Normal LDO operating mode
1 = Load switch mode. FET is either fully on or off depending on the state of LDOEn. When FET is on, the
output is unregulated and is not affected by UVLO’s control block. This setting is internally latched and can
change only when the LDO is disabled.");
            // register 0x0c
            Descriptions(0x0C).Add("Bit [7:5]", "SWSeq[2:0]", @"SW Enable Configuration (Read-Only)
000 = Disabled
001 = Enabled always when BAT/SYS is present
010 = Enabled at 0% of Boot/POR Process Delay Control
011 = Enabled at 25% of Boot/POR Process Delay Control
100 = Enabled at 50% of Boot/POR Process Delay Control
101 = Disabled
110 = Controlled by SWEN (MAX14750)
111 = Controlled by SWEn[1:0] after 100% of Boot/POR Process Delay Control");
            Descriptions(0x0C).Add("Bit [2:1]", "SWSoftStart", @"SW Enable Configuration (effective only when SWSeq[2:0] == 111)
00 = Disabled
01 = Enabled
10 = Enabled when MPC is high
11 = Reserved");
            // register 0x0d
            Descriptions(0x0d).Add("Bit [5:4]", "BCVTm[1:0]", @"Battery Cell Voltage Timing
00: Skip battery measurement
01: Take battery measurement after 10ms delay
10: Take battery measurement after 100ms delay
11: Take battery measurement after 1000ms delay");
            Descriptions(0x0d).Add("Bit [3:2]", "OCVTm[1:0]", @"Battery Open Cell Voltage Timing
If this step is skipped, LCV measurement will be taken with switch closed
00: Skip OCV measurement
01: Take OCV measurement after 10ms delay
10: Take OCV measurement after 100ms delay
11: Take OCV measurement after 1000ms delay");
            Descriptions(0x0d).Add("Bit [1:0]", "LCVTm[1:0]", @"Battery Loaded Cell Voltage Timing
00: Skip LCV measurement
01: Take LCV measurement after 10ms delay
10: Take LCV measurement after 100ms delay
11: Take LCV measurement after 1000ms delay");
            // register 0x0e
            Descriptions(0x0e).Add("Bit 7", "BIA", @"Battery Impedance Active
Write 1 to start battery impedance measurement. If the measurement is already running, the write is ignored.
Bit will remain high until the measurement is completed.
0: Battery impedance measurement is not ongoing
1: Battery impedance measurement is ongoing");
            Descriptions(0x0e).Add("Bit 6", "BIMAbort", @"Battery Impedance Measurement Skip
Write 1 to immediately abort the battery impedance measurement
0: Battery impedance measurement is aborted
1: Battery impedance measurement is not aborted yet");
            Descriptions(0x0e).Add("Bit 3", "LcvDly2Skip", @"Write 1 to skip the second delay time (equal again to LCVTm) after LCV Measurement is taken. This second
delay time allows VCC to recover its unloaded value before closing the power switch again.
0: Wait second delay time
1: Skip second delay time");
            Descriptions(0x0e).Add("Bit [2:0]", "BatimpCur[2:0]", @"Battery Impedance Current
000: 0
001: 250µA
010: 500µA
011: 1mA
100: 2mA
101: 4mA
110: 8mA
111: Reserved");
            // register 0x0f
            Descriptions(0x0f).Add("Bit [7:0]", "BatV[7:0]", @"Battery Voltage Measurement Result
8-bit battery voltage measurement: VCC = [ 2.6 * (BCV[7:0]/255) + 1.1 ] V
If BCVTm[2:0] = 00, BCV[7:0] = 0000 0000.
If error occurs or the measurement is aborted, BCV[7:0] =1111 1111.");
            // register 0x10
            Descriptions(0x10).Add("Bit [7:0]", "BatOCV[7:0]", @"Battery Voltage Measurement Result
8-bit battery voltage measurement: VCC = [2.6 x (OCV[7:0]/255) + 1.1] V
If OCVTm[2:0] = 00, OCV[7:0] =0000 0000.
If error occurs or the measurement is aborted, OCV[7:0] =1111 1111.");
            // register 0x11
            Descriptions(0x11).Add("Bit [7:0]", "LCV[7:0]", @"Battery Voltage Measurement Result
8 bit battery voltage measurement: VCC = [2.6 x ( LCV[7:0]/255) + 1.1] V
If LCVTm[2:0] = 00, BCV[7:0] = 0000 0000.
If error occurs or the measurement is aborted, LCV[7:0] =1111 1111.");
            // register 0x19
            Descriptions(0x19).Add("Bit 7", "MonEn", @"Monitor Enable
0 = Monitor function disabled
1 = Monitor function enabled");
            Descriptions(0x19).Add("Bit 3", "MONtHiZ", @"MON OFF MODE Condition
0 = Pulled Low by a 100k Pulldown Resistor
1 = Hi-Z");
            Descriptions(0x19).Add("Bit [2:0]", "MONCtr[2:0]", @"MON Pin Source Selection
000 = MON connected to SWIN
001 = MON connected to SWOUT
010 = MON connected to BIN
011 = MON connected to BOUT
100 = MON connected to HVIN
101 = MON connected to HVOUT
110 = MON connected to LIN
111 = MON connected to LOUT");
            // register 0x1a
            Descriptions(0x1a).Add("Bit [7:4]", "PwrRstCfg[4:0]", @"0000: Pin Controlled (MAX14750)
0110: Push-Button Monitor (MAX14720)");
            Descriptions(0x1a).Add("Bit 3", "SftRstCfg", @"Soft Reset Register Default
0 = Registers do not reset to default values on soft reset
1 = Registers reset to default values on soft reset");
            Descriptions(0x1a).Add("Bit 2", "PFNPUDCfg", @"KIN Pullup/Pulldown Configuration
0 = Pullups and pulldowns on control lines disabled
1 = Selective pullups and pulldowns enabled on KIN pin");
            Descriptions(0x1a).Add("Bit [1:0]", "BootDly[1:0]", @"Boot/POR Process tRESET Delay Control
00 = 80ms
01 = 120ms
10 = 220ms
11 = 420ms");
            // register 0x1b
            Descriptions(0x1a).Add("Bit 3", "/KIN", @"Input State
0 = Pin low
1 = Pin high");
            Descriptions(0x1a).Add("Bit 2", "/KOUT", @"Input State
0 = Pin low
1 = Pin high");
            Descriptions(0x1a).Add("Bit 1", "MPC", @"Input State
0 = Pin low
1 = Pin high");
            Descriptions(0x1a).Add("Bit 0", "/RST", @"Input State
0 = Pin low
1 = Pin high");
            // register 0x1c
            Descriptions(0x1c).Add("Bit 7", "BoostHysOff", @"Boost Hysteresis Off
0 = Enable comparator hysteresis
1 = Disable comparator hysteresis (recommended to reduce voltage ripple)");
            Descriptions(0x1c).Add("Bit 6", "BoostPacDsc", @"Boost Passive Discharge Control
0: Boost output will be discharged only when entering off and hard-reset modes.
1: Boost output will be discharged only when entering off and hard-reset modes and when BoostEn is set to 00.");
            Descriptions(0x1c).Add("Bit 5", "BoostActDsc", @"Boost Active Discharge Control
0: Boost output will be discharged only when entering off and hard-reset modes.
1: Boost output will be discharged only when entering off and hard-reset modes and when BoostEn is set to 00.");
            Descriptions(0x1c).Add("Bit 2", "BuckActDsc", @"Buck Passive Discharge Control
0: Buck output will be discharged only when entering off and hard-reset modes.
1: Buck output will be discharged only when entering off and hard-reset modes and when BuckEn is set to 00.");
            Descriptions(0x1c).Add("Bit 1", "BuckActDsc", @"Buck Active Discharge Control
0: Buck output will be discharged only when entering off and hard-reset modes.
1: Buck output will be discharged only when entering off and hard-reset modes and when BuckEn is set to 00.");
            Descriptions(0x1c).Add("Bit 0", "BuckFScl", @"Buck Force FET scaling (it reduces IQ by lowering the nMOS power to 20% of the nominal value)
0: FET Scaling only enabled during the buck turn-on sequence
1: FET Scaling enabled during the buck turn-on sequence and also in the buck active state.");
            // register 0x1d
            Descriptions(0x1d).Add("Bit 7", "StartOff", @"Start In Off
1: The device will start in the off mode.
0: The device begins the power-on sequence after a VCC power on reset.");
            Descriptions(0x1d).Add("Bit 6", "GlbPasDsc", @"Global Passive Discharge
0: Passive discharge loads are disabled in off mode.
1: Passive discharge loads are enabled in off mode.");
            Descriptions(0x1d).Add("Bit 0", "StayOn", @"Processor Handshake
This bit is used to ensure that the processor booted correctly. This bit must be set within 5s of power-on to
prevent the part from shutting down and returning to the power-off condition. This bit has no effect after being
set.
0 = Shutdown 5s after power-on
1 = Stay on");
            // register 0x1e
            Descriptions(0x1e).Add("Bit 1", "BBBUVLOSel", @"Buck/Buck-Boost UVLO Select
0: Buck and buck-boost are turned off/on according to LIN_UVLO thresholds
1: Buck and buck-boost are turned off/on according to BIN_UVLO thresholds");
            Descriptions(0x1e).Add("Bit 0", "LDOUVLOsel", @"LDO UVLO Select
0: LDO is turned off/on according to LIN_UVLO thresholds
1: LDO is turned off/on according to BIN_UVLO thresholds");
            // register 0x1f
            Descriptions(0x1f).Add("Bit [7:0]", "PWROFFCMD[7:0]", @"Power-Off Command
Writing 0xB2 to this register will place the part in the off state/seal mode. Waking up the device from this mode
requires a low pulse on /KIN.
All other codes = Do nothing");
        }
    }
}
