﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform
{
    public class PartialArrayIntAvailableEventArgs : EventArgs
    {
        /// <summary>
        /// Sequential index of the first sample.
        /// </summary>
        public int sampleNumberOffset { get; set; }

        /// <summary>
        /// Red channel (660nm) integer values in time sequence.
        /// </summary>
        public int[] rawRedData { get; set; }

        /// <summary>
        /// Infrared channel (880nm) integer values in time sequence.
        /// </summary>
        public int[] rawIRData { get; set; }

        /// <summary>
        /// Green channel (527nm) integer values in time sequence.
        /// </summary>
        public int[] rawGreenData { get; set; }
    }

}
