﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HealthSensorPlatform
{
    // Code for ECG Input Mux Tab
    public partial class HspForm
    {
        List<RegisterField> bioZInputMuxField = new List<RegisterField>();

        // Needed for dynamic changing of options
        RegisterField biozCalFiftyField;

        void initalizeBioZInputMuxFields()
        {
            string[] enDcloffOptions = { "Disabled*", "ECG Ch.", "BioZ Ch." };
            string[] dcloffIpolOptions = { "P: Pull Up, N: Pull Down*", "P: Pull Down, N: Pull Up" };
            string[] dcloffImagOptions = { "0 nA/Disabled*", "5 nA", "10 nA", "20 nA", "50 nA", "100 nA" };
            string[] dcloffVthOptions = { "VMID ±300 mV*", "VMID ±400 mV", "VMID ±450 mV", "VMID ±500 mV" };

            string[] bmuxOpenpOptions = { "Connected", "Isolated*" };
            string[] bmuxOpennOptions = { "Connected", "Isolated*" };

            string[] enRbiasOptions = { "Disabled*", "ECG Bias", "BIOZ Bias" };
            string[] rBiasvOptions = { "50MΩ", "100MΩ*", "200MΩ" };
            string[] rBiaspOptions = { "Disconnected*", "Connected" };
            string[] rBiasnOptions = { "Disconnected*", "Connected" };

            string[] calEnVcalOptions = { "Disabled*", "Enabled" };
            string[] calVmodeOptions = { "Unipolar*", "Bipolar" };
            string[] calVmagOptions = { "0.25 mV*", "0.50 mV" };
            string[] calFcalOptions = { "FMSTR/128 (~256Hz)", "FMSTR/512 (~64Hz)", "FMSTR/2048 (~16Hz)", "FMSTR/8192 (~4Hz)",
                                      "FMSTR/2^15 (~1Hz)*", "FMSTR/2^17 (~1/4Hz)",  "FMSTR/2^19 (~1/16Hz)", "FMSTR/2^21 (~1/64Hz)" };
            string[] calFiftyOptions = { "Time High", "50%*" };
            string[] calThighOptions = new string[2048/8]; // Assume FMSTR = 32768 Hz
            for (int i = 0; i < 2048/8; i++)
            {
                calThighOptions[i] = (30.52 * i * 8).ToString("F0") + " μs";
            }
            calThighOptions[0] += "*"; // Default

            string[] calPSelOptions = { "None*", "VMID", "VCALP", "VCALN" };
            string[] calNSelOptions = calPSelOptions;

            RegisterField enDcloffField = new RegisterField { Name = "\nEN_DCLOFF", Register = 0x10, Index = 12, Width = 2, Descriptions = enDcloffOptions, Label = lblBioZEnDcloff, Control = cboBioZEnDcloff, Device = max30001 };
            RegisterField dcloffIpolField = new RegisterField { Name = "DCLOFF_IPOL", Register = 0x10, Index = 11, Width = 1, Descriptions = dcloffIpolOptions, Label = lblBioZDcloffIpol, Control = cboBioZDcloffIpol, Device = max30001 };
            RegisterField dcloffImagField = new RegisterField { Name = "DCLOFF_IMAG", Register = 0x10, Index = 8, Width = 3, Descriptions = dcloffImagOptions, Label = lblBioZDcloffImag, Control = cboBioZDcloffImag, Device = max30001 };
            RegisterField dcloffVthField = new RegisterField { Name = "DCLOFF_VTH", Register = 0x10, Index = 6, Width = 2, Descriptions = dcloffVthOptions, Label = lblBioZDcloffVth, Control = cboBioZDcloffVth, Device = max30001 };
            bioZInputMuxField.Add(enDcloffField);
            bioZInputMuxField.Add(dcloffIpolField);
            bioZInputMuxField.Add(dcloffImagField);
            bioZInputMuxField.Add(dcloffVthField);

            RegisterField enUlpLonField = new RegisterField { Name = "\nEN_ULP_LON", Register = 0x10, Index = 22, Width = 2, Descriptions = enDcloffOptions, Label = lblBmuxEnUlpLon, Control = cboBmuxEnUlpLon, Device = max30001 };
            bioZInputMuxField.Add(enUlpLonField);

            RegisterField bmuxOpenpField = new RegisterField { Name = "BMUX_OPENP", Register = 0x17, Index = 21, Width = 1, Descriptions = bmuxOpenpOptions, Label = lblBioZBmuxOpenp, Control = cboBioZBmuxOpenp, Device = max30001 };
            RegisterField bmuxOpennField = new RegisterField { Name = "BMUX_OPENN", Register = 0x17, Index = 20, Width = 1, Descriptions = bmuxOpennOptions, Label = lblBioZBmuxOpenn, Control = cboBioZBmuxOpenn, Device = max30001 };
            bioZInputMuxField.Add(bmuxOpenpField);
            bioZInputMuxField.Add(bmuxOpennField);

            RegisterField enRbiasField = new RegisterField { Name = "\nEN_RBIAS", Register = 0x10, Index = 4, Width = 2, Descriptions = enDcloffOptions, Label = lblBioZEnRbias, Control = cboBioZEnRbias, Device = max30001 };
            RegisterField rBiasvField = new RegisterField { Name = "RBIASV", Register = 0x10, Index = 2, Width = 2, Descriptions = rBiasvOptions, Label = lblBioZRbiasv, Control = cboBioZRbiasv, Device = max30001 };
            RegisterField rBiaspField = new RegisterField { Name = "RBIASP", Register = 0x10, Index = 1, Width = 1, Descriptions = rBiaspOptions, Label = lblBioZRbiasp, Control = cboBioZRbiasp, Device = max30001 };
            RegisterField rBiasnField = new RegisterField { Name = "RBIASN", Register = 0x10, Index = 0, Width = 1, Descriptions = rBiasnOptions, Label = lblBioZRbiasn, Control = cboBioZRbiasn, Device = max30001 };
            bioZInputMuxField.Add(enRbiasField);
            bioZInputMuxField.Add(rBiasvField);
            bioZInputMuxField.Add(rBiaspField);
            bioZInputMuxField.Add(rBiasnField);

            RegisterField calEnVcalField = new RegisterField { Name = "CAL_EN_VCAL", Register = 0x12, Index = 22, Width = 1, Descriptions = calEnVcalOptions, Label = lblBioZCalEnVcal, Control = cboBioZCalEnVcal, Device = max30001 };
            RegisterField calVmodeField = new RegisterField { Name = "CAL_VMODE", Register = 0x12, Index = 21, Width = 1, Descriptions = calVmodeOptions, Label = lblBioZCalVMode, Control = cboBioZCalVMode, Device = max30001 };
            RegisterField calVmagField = new RegisterField { Name = "CAL_VMAG", Register = 0x12, Index = 20, Width = 1, Descriptions = calVmagOptions, Label = lblBioZCalVmag, Control = cboBioZCalVmag, Device = max30001 };
            RegisterField calFcalField = new RegisterField { Name = "CAL_FCAL", Register = 0x12, Index = 12, Width = 3, Descriptions = calFcalOptions, Label = lblBioZCalFcal, Control = cboBioZCalFcal, Device = max30001 };
            biozCalFiftyField = new RegisterField { Name = "CAL_FIFTY", Register = 0x12, Index = 11, Width = 1, Descriptions = calFiftyOptions, Label = lblBioZCalFifty, Control = cboBioZCalFifty, Device = max30001 };
            RegisterField calThighField = new RegisterField { Name = "CAL_THIGH", Register = 0x12, Index = 3, Width = 8, Descriptions = calThighOptions, Label = lblBioZCalThigh, Control = cboBioZCalThigh, Device = max30001 };
            bioZInputMuxField.Add(calEnVcalField);
            bioZInputMuxField.Add(calVmodeField);
            bioZInputMuxField.Add(calVmagField);
            bioZInputMuxField.Add(calFcalField);
            bioZInputMuxField.Add(biozCalFiftyField);
            bioZInputMuxField.Add(calThighField);

            RegisterField calPSelField = new RegisterField { Name = "BMUX_CALP_SEL", Register = 0x17, Index = 18, Width = 2, Descriptions = calPSelOptions, Label = lblBioZBmuxCalpSel, Control = cboBioZBmuxCalnSel, Device = max30001 };
            RegisterField calNSelField = new RegisterField { Name = "BMUX_CALN_SEL", Register = 0x17, Index = 16, Width = 2, Descriptions = calNSelOptions, Label = lblBioZBmuxCalnSel, Control = cboBioZBmuxCalpSel, Device = max30001 };
            bioZInputMuxField.Add(calPSelField);
            bioZInputMuxField.Add(calNSelField);
        }

        void BioZInputMuxUpdateRegisters()
        {
            internalUpdate = true;
            ReadComboBoxesRegisters(bioZInputMuxField);
            internalUpdate = false;
        }

        private void cboBioZCalFifty_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cboCalFifty.SelectedIndex == 1)
            {
                cboCalThigh.Enabled = false;
            }
            else
            {
                cboCalThigh.Enabled = true;
            }
        }

        private void cboBioZEnDcloff_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }


        private void cboBioZDcloffIpol_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBmuxEnUlpLon_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZBmuxOpenp_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZBmuxOpenn_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZEnRbias_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZRbiasp_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZRbiasn_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZBmuxCalpSel_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZBmuxCalnSel_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }

        private void cboBioZCalEnVcal_SelectedIndexChanged(object sender, EventArgs e)
        {
            redrawBioZMuxImage();
        }


        private void redrawBioZMuxImage()
        {
            //Lead Off Check
            if (picLoff1.Image != null)
                picLoff1.Image.Dispose();
            if (picLoff2.Image != null)
                picLoff2.Image.Dispose();
            if (cboBioZEnDcloff.SelectedIndex == 2)
            {
                
                if (cboBioZDcloffIpol.SelectedIndex == 0)
                {
                    picLoff1.Image = null;
                    picLoff2.Image = Properties.Resources.bioz_input_muxloff2;
                }
                else
                {
                    picLoff1.Image = Properties.Resources.bioz_input_muxloff1;
                    picLoff2.Image = null;
                }
            }
            else
            {
                picLoff1.Image = null;
                picLoff2.Image = null;
            }

            //Lead On Check Enable
            if (picLeadOn.Image != null)
                picLeadOn.Image.Dispose();
            if (cboBmuxEnUlpLon.SelectedIndex == 2)
            {
                picLeadOn.Image = Properties.Resources.bioz_input_muxlon;
            }
            else
            {
                picLeadOn.Image = null;
            }

            //Switches
            if (picBioZsw1.Image != null)
                picBioZsw1.Image.Dispose();
            if (picBioZsw2.Image != null)
                picBioZsw2.Image.Dispose();
            if (cboBioZBmuxOpenp.SelectedIndex == 0) //if BIP "Connected"
            {
                picBioZsw1.Image = Properties.Resources.bioz_input_muxsw1;
            }
            else
            {
                picBioZsw1.Image = null;
            }
            if (cboBioZBmuxOpenn.SelectedIndex == 0) //if BIN "Connected"
            {
                picBioZsw2.Image = Properties.Resources.bioz_input_muxsw2;
            }
            else
            {
                picBioZsw2.Image = null;
            }

            //Lead Bias
            if (picLeadBias1.Image != null)
                picLeadBias1.Image.Dispose();
            if (picLeadBias2.Image != null)
                picLeadBias2.Image.Dispose();
            if (cboBioZEnRbias.SelectedIndex == 2)
            {
                if (cboBioZRbiasp.SelectedIndex == 1)
                {
                    picLeadBias1.Image = Properties.Resources.bioz_input_muxlb1;
                }
                else
                {
                    picLeadBias1.Image = null;
                }

                if (cboBioZRbiasn.SelectedIndex == 1)
                {
                    picLeadBias2.Image = Properties.Resources.bioz_input_muxlb2;
                }
                else
                {
                    picLeadBias2.Image = null;
                }  
            }
            else
            {
                picLeadBias1.Image = null;
                picLeadBias2.Image = null;
            }

            //Calibration
            if (picBioZCal1.Image != null)
                picBioZCal1.Image.Dispose();
            if (picBioZCal2.Image != null)
                picBioZCal2.Image.Dispose();
            if (cboBioZCalEnVcal.SelectedIndex == 1)
            {
                if (cboBioZBmuxCalpSel.SelectedIndex == 1 | 
                    cboBioZBmuxCalpSel.SelectedIndex == 2 |
                    cboBioZBmuxCalpSel.SelectedIndex == 3)
                {
                    picBioZCal1.Image = Properties.Resources.bioz_input_muxcal1;
                }
                else
                {
                    picBioZCal1.Image = null;
                }
                if (cboBioZBmuxCalnSel.SelectedIndex == 1 |
                    cboBioZBmuxCalnSel.SelectedIndex == 2 |
                    cboBioZBmuxCalnSel.SelectedIndex == 3)
                {
                    picBioZCal2.Image = Properties.Resources.bioz_input_muxcal2;
                }
                else
                {
                    picBioZCal2.Image = null;
                }
            }
            else
            {
                picBioZCal1.Image = null;
                picBioZCal2.Image = null;
            }


        }


    }
}
