﻿//#define CES_DEMO
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.InteropServices;

namespace HealthSensorPlatform
{
#if CES_DEMO
    class AlgorithmMobileBU
    {
        // Algorithm from Mobile BU
        public const string DllName = "algo_win.dll";

        public struct AlgorithmOutput
        {
            public double version;
            public double hr;
            public double spo2;
            public double sigQual;
            public double irAC;
            public double irDC;
            public double redAC;
            public double redDC;
            //#ifdef _ELFI_
            public double acLowPerfusion;
            public double irLEDFlag;
            public double redLEDFlag;
            public double flagNoFinger; //Valid only at the first rest before motion
            public double flagMotion;    //is equal to 1 when there is motion
            public double flagHrValid;
            //#endif
            public double hrUpdateFlag;
            public double PA_R;
            public double PA_IR;
            public double PA_V;
            public double ppg; // cetin
            public double raw_without_ppg;
            public double secondary_hr;
            public double secondary_spo2;
            public double source_is_secondary_flag;
            public double raw_ir;
            public double raw_red;
            public double acceleration;

            public double smoothed_ir;
            public double smoothed_red;
            public double v42Tr;
            public double v60Tr;
            public double R_HR;
            public double IRHR;
            public double R_FO;
            public double IRFO;
            public double Clock;
            public double SysClk;
            public double IR_hrupd;
            public double R_hrupd;

            public double pulse_average;
            public double pulse_interval;
            public double hrv;
            public double resp_rate;
            public double heartbeats_reported_in_this_touch;
            public double last_reported_heartbeat_rate;
            public double perfusion;
            public double R;                       // R ratio from SpO2
        };

        public struct AlgorithmConfiguration
        {
            public sbyte snrNoFingerThreshold;  // snr below that threshold will cause flagNoFingerRest to be equal to 1. Valid only at the first few secs rest
            public double acLowPerfusionThreshold; // Threshold for output.acLowPerfusion// Above this threshold flagLowPerfusion == 1
            public int isAGC;
        };

        /// <summary>
        /// Heart Rate and Pulse Ox algorithm
        /// </summary>
        /// <param name="ir"></param>
        /// <param name="r"></param>
        /// <param name="led"></param>
        /// <param name="acThresh"></param>
        /// <param name="fs"></param>
        /// <param name="isReset"></param>
        /// <param name="accel_x"></param>
        /// <param name="accel_y"></param>
        /// <param name="accel_z"></param>
        /// <param name="inputParameters"></param>
        /// <param name="output"></param>
        /// <returns></returns>
        [DllImport(DllName)]
        public static extern int runAlgorithm_win(int ir, int r, int led, int acThresh, int fs, int isReset,
            float accel_x, float accel_y, float accel_z, ref AlgorithmConfiguration inputParameters, ref AlgorithmOutput output);
    }
#endif
}
