/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.media.browse.MediaBrowser;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

class MediaBrowserCompatApi21 {
    static final String NULL_MEDIA_ITEM_ID = "android.support.v4.media.MediaBrowserCompat.NULL_MEDIA_ITEM";

    MediaBrowserCompatApi21() {
    }

    public static Object createConnectionCallback(ConnectionCallback callback) {
        return new ConnectionCallbackProxy<ConnectionCallback>(callback);
    }

    public static Object createBrowser(Context context, ComponentName serviceComponent, Object callback, Bundle rootHints) {
        return new MediaBrowser(context, serviceComponent, (MediaBrowser.ConnectionCallback)callback, rootHints);
    }

    public static void connect(Object browserObj) {
        ((MediaBrowser)browserObj).connect();
    }

    public static void disconnect(Object browserObj) {
        ((MediaBrowser)browserObj).disconnect();
    }

    public static boolean isConnected(Object browserObj) {
        return ((MediaBrowser)browserObj).isConnected();
    }

    public static ComponentName getServiceComponent(Object browserObj) {
        return ((MediaBrowser)browserObj).getServiceComponent();
    }

    public static String getRoot(Object browserObj) {
        return ((MediaBrowser)browserObj).getRoot();
    }

    public static Bundle getExtras(Object browserObj) {
        return ((MediaBrowser)browserObj).getExtras();
    }

    public static Object getSessionToken(Object browserObj) {
        return ((MediaBrowser)browserObj).getSessionToken();
    }

    public static Object createSubscriptionCallback(SubscriptionCallback callback) {
        return new SubscriptionCallbackProxy<SubscriptionCallback>(callback);
    }

    public static void subscribe(Object browserObj, String parentId, Object subscriptionCallbackObj) {
        ((MediaBrowser)browserObj).subscribe(parentId, (MediaBrowser.SubscriptionCallback)subscriptionCallbackObj);
    }

    public static void unsubscribe(Object browserObj, String parentId) {
        ((MediaBrowser)browserObj).unsubscribe(parentId);
    }

    static class SubscriptionCallbackProxy<T extends SubscriptionCallback>
    extends MediaBrowser.SubscriptionCallback {
        protected final T mSubscriptionCallback;

        public SubscriptionCallbackProxy(T callback) {
            this.mSubscriptionCallback = callback;
        }

        public void onChildrenLoaded(@NonNull String parentId, List<MediaBrowser.MediaItem> children) {
            this.mSubscriptionCallback.onChildrenLoaded(parentId, SubscriptionCallbackProxy.itemListToParcelList(children));
        }

        public void onError(@NonNull String parentId) {
            this.mSubscriptionCallback.onError(parentId);
        }

        static List<Parcel> itemListToParcelList(List<MediaBrowser.MediaItem> itemList) {
            if (itemList == null || itemList.size() == 1 && itemList.get(0).getMediaId().equals(MediaBrowserCompatApi21.NULL_MEDIA_ITEM_ID)) {
                return null;
            }
            ArrayList<Parcel> parcelList = new ArrayList<Parcel>();
            for (MediaBrowser.MediaItem item : itemList) {
                Parcel parcel = Parcel.obtain();
                item.writeToParcel(parcel, 0);
                parcelList.add(parcel);
            }
            return parcelList;
        }
    }

    static interface SubscriptionCallback {
        public void onChildrenLoaded(@NonNull String var1, List<Parcel> var2);

        public void onError(@NonNull String var1);
    }

    static class ConnectionCallbackProxy<T extends ConnectionCallback>
    extends MediaBrowser.ConnectionCallback {
        protected final T mConnectionCallback;

        public ConnectionCallbackProxy(T connectionCallback) {
            this.mConnectionCallback = connectionCallback;
        }

        public void onConnected() {
            this.mConnectionCallback.onConnected();
        }

        public void onConnectionSuspended() {
            this.mConnectionCallback.onConnectionSuspended();
        }

        public void onConnectionFailed() {
            this.mConnectionCallback.onConnectionFailed();
        }
    }

    static interface ConnectionCallback {
        public void onConnected();

        public void onConnectionSuspended();

        public void onConnectionFailed();
    }
}

