/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.os.Process;
import com.android.tools.fd.common.Log;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.FileManager;
import com.android.tools.fd.runtime.IncrementalClassLoader;
import com.android.tools.fd.runtime.MonkeyPatcher;
import com.android.tools.fd.runtime.Server;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;

public class BootstrapApplication
extends Application {
    public static final String LOG_TAG = "InstantRun";
    private String externalResourcePath;
    private Application realApplication;

    public BootstrapApplication() {
        android.util.Log.i((String)LOG_TAG, (String)String.format("Instant Run Runtime started. Android package is %s, real application class is %s.", AppInfo.applicationId, AppInfo.applicationClass));
    }

    private void createResources(long apkModified) {
        FileManager.checkInbox();
        File file = FileManager.getExternalResourceFile();
        String string = this.externalResourcePath = file != null ? file.getPath() : null;
        if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
            android.util.Log.v((String)LOG_TAG, (String)("Resource override is " + this.externalResourcePath));
        }
        if (file != null) {
            try {
                long resourceModified = file.lastModified();
                if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                    android.util.Log.v((String)LOG_TAG, (String)("Resource patch last modified: " + resourceModified));
                    android.util.Log.v((String)LOG_TAG, (String)("APK last modified: " + apkModified + " " + (apkModified > resourceModified ? ">" : "<") + " resource patch"));
                }
                if (apkModified == 0L || resourceModified <= apkModified) {
                    if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                        android.util.Log.v((String)LOG_TAG, (String)"Ignoring resource file, older than APK");
                    }
                    this.externalResourcePath = null;
                }
            }
            catch (Throwable t) {
                android.util.Log.e((String)LOG_TAG, (String)"Failed to check patch timestamps", (Throwable)t);
            }
        }
    }

    private static void setupClassLoaders(Context context, String codeCacheDir, long apkModified) {
        List<String> dexList = FileManager.getDexList(context, apkModified);
        Class<Server> server = Server.class;
        Class<MonkeyPatcher> patcher = MonkeyPatcher.class;
        if (!dexList.isEmpty()) {
            String nativeLibraryPath;
            if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                android.util.Log.v((String)LOG_TAG, (String)("Bootstrapping class loader with dex list " + BootstrapApplication.join('\n', dexList)));
            }
            ClassLoader classLoader = BootstrapApplication.class.getClassLoader();
            try {
                nativeLibraryPath = (String)classLoader.getClass().getMethod("getLdLibraryPath", new Class[0]).invoke((Object)classLoader, new Object[0]);
                if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                    android.util.Log.v((String)LOG_TAG, (String)("Native library path: " + nativeLibraryPath));
                }
            }
            catch (Throwable t) {
                android.util.Log.e((String)LOG_TAG, (String)("Failed to determine native library path " + t.getMessage()));
                nativeLibraryPath = FileManager.getNativeLibraryFolder().getPath();
            }
            IncrementalClassLoader.inject(classLoader, nativeLibraryPath, codeCacheDir, dexList);
        } else {
            android.util.Log.w((String)LOG_TAG, (String)"No instant run dex files added to classpath");
        }
    }

    public static String join(char on, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String item : list) {
            stringBuilder.append(item).append(on);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRealApplication() {
        if (AppInfo.applicationClass != null) {
            if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                android.util.Log.v((String)LOG_TAG, (String)("About to create real application of class name = " + AppInfo.applicationClass));
            }
            try {
                Class<?> realClass = Class.forName(AppInfo.applicationClass);
                if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                    android.util.Log.v((String)LOG_TAG, (String)("Created delegate app class successfully : " + realClass + " with class loader " + realClass.getClassLoader()));
                }
                Constructor<?> constructor = realClass.getConstructor(new Class[0]);
                this.realApplication = (Application)constructor.newInstance(new Object[0]);
                if (!android.util.Log.isLoggable((String)LOG_TAG, (int)2)) return;
                android.util.Log.v((String)LOG_TAG, (String)("Created real app instance successfully :" + this.realApplication));
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.realApplication = new Application();
        }
    }

    protected void attachBaseContext(Context context) {
        if (!AppInfo.usingApkSplits) {
            String apkFile = context.getApplicationInfo().sourceDir;
            long apkModified = apkFile != null ? new File(apkFile).lastModified() : 0L;
            this.createResources(apkModified);
            BootstrapApplication.setupClassLoaders(context, context.getCacheDir().getPath(), apkModified);
        }
        this.createRealApplication();
        super.attachBaseContext(context);
        if (this.realApplication != null) {
            try {
                Method attachBaseContext = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
                attachBaseContext.setAccessible(true);
                attachBaseContext.invoke((Object)this.realApplication, context);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Context c = this.realApplication.createPackageContext(packageName, flags);
        return c == null ? this.realApplication : c;
    }

    public void registerComponentCallbacks(ComponentCallbacks callback) {
        this.realApplication.registerComponentCallbacks(callback);
    }

    public void registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback) {
        this.realApplication.registerActivityLifecycleCallbacks(callback);
    }

    public void registerOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback) {
        this.realApplication.registerOnProvideAssistDataListener(callback);
    }

    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        this.realApplication.unregisterComponentCallbacks(callback);
    }

    public void unregisterActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback) {
        this.realApplication.unregisterActivityLifecycleCallbacks(callback);
    }

    public void unregisterOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback) {
        this.realApplication.unregisterOnProvideAssistDataListener(callback);
    }

    public void onCreate() {
        if (!AppInfo.usingApkSplits) {
            MonkeyPatcher.monkeyPatchApplication((Context)this, this, this.realApplication, this.externalResourcePath);
            MonkeyPatcher.monkeyPatchExistingResources((Context)this, this.externalResourcePath, null);
        } else {
            MonkeyPatcher.monkeyPatchApplication((Context)this, this, this.realApplication, null);
        }
        super.onCreate();
        if (AppInfo.applicationId != null) {
            try {
                boolean startServer;
                boolean foundPackage = false;
                int pid = Process.myPid();
                ActivityManager manager = (ActivityManager)this.getSystemService("activity");
                List processes = manager.getRunningAppProcesses();
                if (processes != null && processes.size() > 1) {
                    startServer = false;
                    for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
                        if (!AppInfo.applicationId.equals(processInfo.processName)) continue;
                        foundPackage = true;
                        if (processInfo.pid != pid) continue;
                        startServer = true;
                        break;
                    }
                    if (!startServer && !foundPackage) {
                        startServer = true;
                        if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                            android.util.Log.v((String)LOG_TAG, (String)"Multiprocess but didn't find process with package: starting server anyway");
                        }
                    }
                } else {
                    startServer = true;
                }
                if (startServer) {
                    Server.create(AppInfo.applicationId, this);
                }
            }
            catch (Throwable t) {
                if (android.util.Log.isLoggable((String)LOG_TAG, (int)2)) {
                    android.util.Log.v((String)LOG_TAG, (String)"Failed during multi process check", (Throwable)t);
                }
                Server.create(AppInfo.applicationId, this);
            }
        }
        if (this.realApplication != null) {
            this.realApplication.onCreate();
        }
    }

    static {
        Log.logging = new Log.Logging(){

            @Override
            public void log(Level level, String string) {
                this.log(level, string, null);
            }

            @Override
            public boolean isLoggable(Level level) {
                if (level == Level.SEVERE) {
                    return android.util.Log.isLoggable((String)BootstrapApplication.LOG_TAG, (int)6);
                }
                if (level == Level.FINE) {
                    return android.util.Log.isLoggable((String)BootstrapApplication.LOG_TAG, (int)2);
                }
                return android.util.Log.isLoggable((String)BootstrapApplication.LOG_TAG, (int)4);
            }

            @Override
            public void log(Level level, String string, Throwable throwable) {
                if (level == Level.SEVERE) {
                    if (throwable == null) {
                        android.util.Log.e((String)BootstrapApplication.LOG_TAG, (String)string);
                    } else {
                        android.util.Log.e((String)BootstrapApplication.LOG_TAG, (String)string, (Throwable)throwable);
                    }
                } else if (level == Level.FINE) {
                    if (android.util.Log.isLoggable((String)BootstrapApplication.LOG_TAG, (int)2)) {
                        if (throwable == null) {
                            android.util.Log.v((String)BootstrapApplication.LOG_TAG, (String)string);
                        } else {
                            android.util.Log.v((String)BootstrapApplication.LOG_TAG, (String)string, (Throwable)throwable);
                        }
                    }
                } else if (android.util.Log.isLoggable((String)BootstrapApplication.LOG_TAG, (int)4)) {
                    if (throwable == null) {
                        android.util.Log.i((String)BootstrapApplication.LOG_TAG, (String)string);
                    } else {
                        android.util.Log.i((String)BootstrapApplication.LOG_TAG, (String)string, (Throwable)throwable);
                    }
                }
            }
        };
    }
}

