/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.view;

import android.graphics.Point;
import android.support.v4.view.MotionEventCompat;
import android.view.MotionEvent;
import android.view.View;

public class DragStartHelper {
    private final View mView;
    private final OnDragStartListener mListener;
    private int mLastTouchX;
    private int mLastTouchY;
    private final View.OnLongClickListener mLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            return DragStartHelper.this.onLongClick(v);
        }
    };
    private final View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            return DragStartHelper.this.onTouch(v, event);
        }
    };

    public DragStartHelper(View view, OnDragStartListener listener) {
        this.mView = view;
        this.mListener = listener;
    }

    public void attach() {
        this.mView.setOnLongClickListener(this.mLongClickListener);
        this.mView.setOnTouchListener(this.mTouchListener);
    }

    public void detach() {
        this.mView.setOnLongClickListener(null);
        this.mView.setOnTouchListener(null);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0 || event.getAction() == 2) {
            this.mLastTouchX = (int)event.getX();
            this.mLastTouchY = (int)event.getY();
        }
        if (event.getAction() == 2 && MotionEventCompat.isFromSource((MotionEvent)event, (int)8194) && (MotionEventCompat.getButtonState((MotionEvent)event) & 1) != 0) {
            return this.mListener.onDragStart(v, this);
        }
        return false;
    }

    public boolean onLongClick(View v) {
        return this.mListener.onDragStart(v, this);
    }

    public void getTouchPosition(Point point) {
        point.set(this.mLastTouchX, this.mLastTouchY);
    }

    public static interface OnDragStartListener {
        public boolean onDragStart(View var1, DragStartHelper var2);
    }
}

