//
// RUTINAS DE ACCESO AL RELOJ
//
#include "mbed.h"
#include "declaraciones.h"

extern st_datos_servo datos_servo;       // ESTRUCTURA DE VARIABLES DE ESTADO DEL SERVO DE DIRECCION

//DigitalOut myled(LED1);




void getTime() {
    time_t timestamp = time(NULL);
    printf("Time: %lu\r\n", timestamp);
}
    

time_t asUnixTime(int year, int mon, int mday, int hour, int min, int sec) {
    struct tm   t;
    t.tm_year = year - 1900;
    t.tm_mon =  mon - 1;        // convert to 0 based month
    t.tm_mday = mday;
    t.tm_hour = hour;
    t.tm_min = min;
    t.tm_sec = sec;
    t.tm_isdst = -1;            // Is Daylight saving time on? 1 = yes, 0 = no, -1 = unknown
 
    return mktime(&t);          // returns seconds elapsed since January 1, 1970 (begin of the Epoch)
}



void actualizaFechaHoraGPS(float fecha, float hora){
int year, mon, day, hour, min, sec;

//    printf("fecha:%f hora:%f\r\n", fecha, hora);

    day = (int)(fecha/10000);
    mon = (int)((fecha-day*10000)/100);
    year = ((int)fecha)%100;
    hour = (int)(hora/10000);
    min = (int)((hora-hour*10000)/100);
    sec = ((int)hora)%100;

//    printf("%02d-%02d-%02d %02d:%02d:%02d\r\n", day, mon, year, hour, min, sec);

    time_t epoch =  asUnixTime(year+2000, mon, day, hour, min, sec); 
//    printf("epoch:%lu\r\n", epoch);
    datos_servo.fecha_hora = epoch-946684800L;

    set_time(epoch);  // Sincroniza con fecha hora del GPS   

//    set_time(1597521600);  // Set RTC time to Wed, 28 Oct 2009 11:35:37    

}

