//
// RUTINAS DE CONTROL DE TIMONES
//

#include "declaraciones.h"


extern volatile st_datos_servo datos_servo;      // ESTRUCTURA DE VARIABLES DE ESTADO DEL SERVO DE DIRECCION
extern volatile st_datos_servo datos_otro_servo; // ESTRUCTURA DE VARIABLES DE ESTADO DEL OTRO SERVO DE DIRECCION
extern int cons_timon_babor;            // consigna % de timon babor bajado
extern int cons_timon_estribor;         // consigna % de timon estribor bajado
extern long desviacion_servo;
extern int16_t torque_servo;            // torque del servo
extern float diferencia_rumbo;          // Diferencia al Rumbo deseado
extern volatile int pos_objetivo_servo;
extern volatile bool f_actualiza_tim_trans;     // Pone flag para actualizar timones y transmision




/*******************************************************************************
// devuelve diferencia del rumbo actual al fijado
// si es positiva debe girar a estribor, si negativa a babor
*******************************************************************************/
float dif_rumbo(float rumbo_actual, float rumbo_deseado){

  float dif = rumbo_deseado - rumbo_actual;
  if(dif < -180.0)
    dif += 360;
  else if(dif > 180)
    dif -= 360;
  dif = constrain(dif, -180.0, 180.0);
    
  return (dif);
}



#define VELOCIDAD_MAX 70.0
#define HISTERESIS_RUMBO 0.5
#define FACTOR_INTEGRAL_TIMON 0.01   //0.3 para 100% en 30s

/*******************************************************************************
// devuelve el valor maximo de timón en % según la velocidad
*******************************************************************************/
float max_timon(float velocidad){

  velocidad = constrain(velocidad, 0.0, VELOCIDAD_MAX);
  float max = 80 * (velocidad * velocidad)/(VELOCIDAD_MAX * VELOCIDAD_MAX);
  max = constrain(100-max, 20.0, 100.0);

  return max;
}





/*******************************************************************************
// actualiza posición de los timones en piloto automatico segun rumbo actual, deseado, velocidad y tiempo
*******************************************************************************/
void pos_timones_p_automatico( float rumbo_actual, float rumbo_deseado, float velocidad){
  static float rumbo_anterior = 0.0;
  static float tiempo = 0.0;
  static long tiempo_ms = 0;

  if(rumbo_deseado != rumbo_anterior){
    tiempo = 0.0;
    tiempo_ms = millis();
    rumbo_anterior = rumbo_deseado;  
  }
  else{ // imncrementa tiempo
    tiempo += ((millis()-tiempo_ms)/1000.0);
  }
  diferencia_rumbo = dif_rumbo(rumbo_actual, rumbo_deseado);
  if( abs(diferencia_rumbo) > HISTERESIS_RUMBO){
    // Recalcula valores para los timones
    float timon = abs(diferencia_rumbo)/180.0*100.0;             // Valor proporcional
    timon += abs(diferencia_rumbo)*(tiempo/10)*FACTOR_INTEGRAL_TIMON; // Valor Integral
    if(diferencia_rumbo > 0.0){  // Rumbo a estribor, baja timón de estribor
      timon = constrain(timon, datos_servo.trim_timon_estr, max_timon(velocidad)); // Ajusta al valor máximo de acuerdo con la velocidad y el offset
      cons_timon_babor = datos_servo.trim_timon_bab;  // pone a valor mínimo
      cons_timon_estribor = timon;
    }
    else { // Rumbo a babor, baja timón de babor
      timon = constrain(timon, datos_servo.trim_timon_bab, max_timon(velocidad)); // Ajusta al valor máximo de acuerdo con la velocidad y el offset
      cons_timon_estribor = datos_servo.trim_timon_estr;  // pone a valor mínimo
      cons_timon_babor = timon;      
    }
  }
  else{
    cons_timon_babor = datos_servo.trim_timon_bab;  // pone a valor mínimo
    cons_timon_estribor = datos_servo.trim_timon_estr;      // pone a valor mínimo
  }
}



/*******************************************************************************
 * SINCRONIZA SERVOS ENTRE ELLOS SEGUN SU ESTADO
 ******************************************************************************/
void sincroniza_servos(void){

    if(datos_otro_servo.estado != DIR_REPOSO){
        pos_objetivo_servo = (int16_t)datos_otro_servo.posicion_mando;
        printf("pos_objetivo_servo=%d\r\n", pos_objetivo_servo);
        datos_servo.rumbo = datos_otro_servo.rumbo;
    }
}



int rumbosPiloto[]={0,30,0,270,300,0,10,120,330,350};
int rumbosRumboFijo[]={0,179,0,181,0,179,0,181,0,179};
//int rumbosRumboFijo[]={0,5,235,355,10,0,245,0,350,150};

/*******************************************************************************
 * PROCESA PILOTO AUTOMATICO SI ESTA CONECTADO, PROCESA CADA PERIODO (25ms)
 ******************************************************************************/
void procesa_piloto_automatico(){
static int cnt_torque_max = 0;

    if(datos_servo.estado == DIR_PILOTO || datos_servo.estado == DIR_RUMBO){
      if(torque_servo >= TORQUE_MAX_PILOTO_AUTO){
        if(++cnt_torque_max>10){  // Salida de piloto automatico
          datos_servo.estado = DIR_REPOSO;
          printf("Sale de PILOTO por torque maximo\r\n");
        }
      }
      else
        cnt_torque_max = 0;
    }
    if(datos_servo.estado == DIR_PILOTO){
      int i = (millis()/10000L)%10;
      datos_servo.rumbo_piloto_auto = rumbosPiloto[i];
      pos_timones_p_automatico( datos_servo.rumbo, datos_servo.rumbo_piloto_auto, datos_servo.velocidad);
    }
    else if(datos_servo.estado == DIR_RUMBO){
      int i = (millis()/20000L)%10;
//      DEBUG_PORT.println(i);
      datos_servo.rumbo_fijado = rumbosRumboFijo[i];
      pos_timones_p_automatico( datos_servo.rumbo, datos_servo.rumbo_fijado, datos_servo.velocidad);
    }
    else{
//      pos_objetivo_servo = 0;
      actualiza_timones();  // MANUAL
    }
    if(datos_servo.estado == DIR_PILOTO || datos_servo.estado == DIR_RUMBO){
      long difTimones = datos_servo.timon_babor - datos_servo.timon_estribor;
      pos_objetivo_servo -= (pos_objetivo_servo-((difTimones * DESVIACION_MAXIMA) / 100))/10;
    }
}


//***************************************************************
// * ACTUALIZA TIMONES
//***************************************************************
void actualiza_timones(){   // ACTUALIZA TIMONES

  // ACTIVA TIMONES SEGUN DESVIACION
  if(desviacion_servo >= 40){
    cons_timon_babor = map(abs(desviacion_servo-40), 0, DESVIACION_MAXIMA, datos_servo.trim_timon_bab, 100);
    cons_timon_estribor = datos_servo.trim_timon_estr;
    if(cons_timon_babor <= TIMONES_HIST)
      cons_timon_babor = datos_servo.trim_timon_bab;
  }
  else if(desviacion_servo <= -40){
    cons_timon_estribor = map(abs(desviacion_servo+40), 0, DESVIACION_MAXIMA, datos_servo.trim_timon_estr, 100);
    cons_timon_babor = datos_servo.trim_timon_bab;
     if(cons_timon_estribor <= TIMONES_HIST)
      cons_timon_estribor = datos_servo.trim_timon_estr;
  }
  else{
      cons_timon_babor = datos_servo.trim_timon_bab;
      cons_timon_estribor = datos_servo.trim_timon_estr;      
  }
}


#define SALTO_TIMON 5   //5% cada 250ms


//***************************************************************
// Pocesa activación y posición timones, llamada cada 250ms
//***************************************************************
void  procesa_posicion_timones(void){


//    printf("cons_timon_babor:%d timon_babor:%d\r\n", cons_timon_babor, datos_servo.timon_babor );
//    printf("cons_timon_estribor:%d timon_estribor:%d\r\n", cons_timon_estribor, datos_servo.timon_estribor );

    datos_servo.timon_babor = cons_timon_babor;
    datos_servo.timon_estribor = cons_timon_estribor;
    
/*
    if(abs(cons_timon_babor - datos_servo.timon_babor) > TIMONES_HIST){
        printf("dif=%d\r\n", abs(cons_timon_babor - datos_servo.timon_babor) );
        // Si la diferencia es mayor que la histeresis, mueve timon
        if(cons_timon_babor > datos_servo.timon_babor){
            if(datos_servo.timon_estribor <= datos_servo.trim_timon_estr)
            datos_servo.timon_babor += SALTO_TIMON; // SALTO_TIMON% cada 250ms
        }
        else{
            datos_servo.timon_babor -= SALTO_TIMON; // -SALTO_TIMON% cada 250ms
            if(datos_servo.timon_babor > 127)
                datos_servo.timon_babor=0;
        }
    }
    else{
        // para movimiento del timon
        datos_servo.timon_babor = cons_timon_babor;
    }
        
    if(abs(cons_timon_estribor - datos_servo.timon_estribor) > TIMONES_HIST){
        // Si la diferencia es mayor que la histeresis, mueve timon
        if(cons_timon_estribor > datos_servo.timon_estribor){
            if(datos_servo.timon_babor <= datos_servo.trim_timon_bab)
                datos_servo.timon_estribor += SALTO_TIMON; // SALTO_TIMON% cada 100ms
        }
        else{
            datos_servo.timon_estribor -= SALTO_TIMON; // -SALTO_TIMON% cada 100ms
            if(datos_servo.timon_estribor > 127)
                datos_servo.timon_estribor=0;
        }
    }
    else{
        // para movimiento del timon
        datos_servo.timon_estribor = cons_timon_estribor;
    }
*/

}

