/*
// Proceso de actuación sobre pulsadores, recibido desde el mando
*/
#include "declaraciones.h"


extern st_datos_servo datos_servo;              // ESTRUCTURA DE VARIABLES DE ESTADO DEL SERVO DE DIRECCION
extern st_datos_servo datos_otro_servo;         // ESTRUCTURA DE VARIABLES DE ESTADO DEL OTRO SERVO DE DIRECCION
extern long desviacion_servo;
extern volatile int pos_actual_servo;
extern volatile int pos_objetivo_servo;


// ******************************************************
// Procesa segun estado de los pulsadores del mando
// ******************************************************
void procesa_pulsadores(uint8_t pulsadores){     // Procesa segun estado de los pulsadores del mando
static unsigned long tiempo_pulsado_rumbo = 0;               // tiempo que se ha mantenido pulsado RUMBO

    
    if(pulsadores & MASK_PULS_RUMBO != 0){      // BOTON PULSADO
        if(tiempo_pulsado_rumbo == 0){
            tiempo_pulsado_rumbo = millis();     // devuelve cuenta de tiempo en ms
        }
        if(datos_servo.estado == DIR_PILOTO || datos_otro_servo.estado == DIR_PILOTO || datos_servo.estado == DIR_RUMBO || datos_otro_servo.estado == DIR_RUMBO) { // Si algun servo esta en RUMBO o PILOTO
            datos_servo.estado = DIR_END_PILOT;     // Finaliza PILOTO        
            printf("Finaliza RUMBO o PILOTO estado otro:%d estado:%d\r\n", datos_otro_servo.estado, datos_servo.estado);
        }
    }
    else {  // Se ha soltado el boton
        unsigned long pulsado_ms = millis()-tiempo_pulsado_rumbo;

        if(tiempo_pulsado_rumbo != 0 && pulsado_ms >= 2000){
            // Activa RUMBO o PILOTO
            if(datos_servo.estado == DIR_REPOSO && datos_otro_servo.estado == DIR_REPOSO) { // Si los dos servos estan en reposo
                if(pulsado_ms >= 4000){
                    datos_servo.estado = DIR_PILOTO;     // Pone en PILOTO AUT  
                    printf("En PILOTO estado otro:%d estado:%d\r\n", datos_otro_servo.estado, datos_servo.estado);
                }              
                else if(pulsado_ms < 10000){            
                    datos_servo.estado = DIR_RUMBO;     // Pone en RUMBO
                    printf("En RUMBO estado otro:%d estado:%d\r\n", datos_otro_servo.estado, datos_servo.estado);
                }
            }
        }
        tiempo_pulsado_rumbo = 0;
    }
}

