/********************************************************************
// RUTINAS DE COMUNICACION POR ETHERNET PARA MONITORES Y PLCs
********************************************************************/

#include "declaraciones.h"
#include "EthernetInterface.h"

 
// Network interface
extern EthernetInterface net;


#define BROADCAST_PORT 37



extern ntp_packet in_data;
extern bool newtime;

extern st_datos_servo datos_servo;      // ESTRUCTURA DE VARIABLES DE ESTADO DEL SERVO DE DIRECCION
extern DigitalIn SEL0;                  //Selector 1 = BABOR/ESTRIBOR, ON=BABOR OFF=ESTRIBOR
extern DigitalOut led2;                 //LED1

extern int babor_estribor;          // 0=babor 1=estribor                


/*
    uint8_t cmd_r[]={0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x01, 0x04, 0x70, 0x12, 0x00, 0x04};
    uint8_t cmd_w1[]={0x00,0x03,0x00,0x00,0x00,0x0F,0x01,0x10,0x70,0x12,0x00,0x04,0x08,0x00,0x00,0x40,0x40,0xD7,0x0A,0x40,0x73}; // pone a min=3.0 (40 40 00 00), max=3.8 (40 73 D7 0A)
    uint8_t cmd_w2[]={0x00,0x03,0x00,0x00,0x00,0x0F,0x01,0x10,0x70,0x12,0x00,0x04,0x08,0x00,0x00,0x40,0x80,0x51,0xEC,0x40,0xA0}; // pone a min=4.0 (40 80 00 00), max=5.01 (40 A0 51 EC)


// *******************************************************************************
// * ENVIA TRAMA MODBUS
// *******************************************************************************
void envia_trama_modbus(){

    static long tiempo = millis();
    static byte timon_babor_old;        // %de timon babor bajado, para 100% 5s, 1% = 50ms
    static byte timon_estribor_old;     // %de timon estribor bajado, para 100% 5s


    if( (timon_babor_old == datos_servo.timon_babor && timon_estribor_old == datos_servo.timon_estribor) || (millis()-tiempo)<1000 )
        return; // Si no ha cambiado, no lo envia
    timon_babor_old = datos_servo.timon_babor;
    timon_estribor_old = datos_servo.timon_estribor;

    float hist = 0.2;
    long v_max = 8000;
    long v_min = 3000;
    
    float val_tb_min = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000);
    float val_tb_max = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000)+hist;
    float val_te_min = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000);
    float val_te_max = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000)+hist;

    uint8_t *p_tb_min = (uint8_t *)&val_tb_min;
    uint8_t *p_tb_max = (uint8_t *)&val_tb_max;
    uint8_t *p_te_min = (uint8_t *)&val_te_min;
    uint8_t *p_te_max = (uint8_t *)&val_te_max;
    
//    printf("tb=%.2f te=%.2f\r\n", val_tb_min, val_te_min);
//    PrintHex8(p_tb_min, 4);       // prints 8-bit data in hex with leading zeroes
//    printf("\r\n");


    // Show the network address
    SocketAddress a;

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    TCPSocket socket;
    socket.open(&net);
    socket.set_timeout(10);

    a.set_port(502);
    a.set_ip_address("192.168.1.200");
    socket.connect(a);
    
    // Send a simple http request
    uint8_t buf[40];
    memcpy(buf, cmd_w1, sizeof cmd_w1);
    buf[13] = p_tb_min[1];
    buf[14] = p_tb_min[0];
    buf[15] = p_tb_min[3];
    buf[16] = p_tb_min[2];
    buf[17] = p_tb_max[1];
    buf[18] = p_tb_max[0];
    buf[19] = p_tb_max[3];
    buf[20] = p_tb_max[2];
    
    int scount = socket.send(buf, sizeof cmd_w1);
//    printf("sent %d bytes\r\n", scount);
    printf(">%d\r\n", millis()-tiempo);


    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
//    printf("recv %dbytes\r\n", rcount);
//    PrintHex8((uint8_t *)rbuffer, rcount);       // prints 8-bit data in hex with leading zeroes
//    printf("\r\n");
    printf("<%d\r\n", millis()-tiempo);
    tiempo = millis();


    // Close the socket to return its memory and bring down the network interface
    socket.close();
}



//void onTCPSocketEvent(void* buffer, size_t size) {
//    printf("TCP: bytes %d\r\n", size);     
//}
*/


/*
 * ENVIA TRAMA DE ESTADO DEL CONTROL SERVO 0=babor 1=estribor
 */
void envia_trama_estado(){
    static st_datos_servo datos_ant;  // ultimos datos enviados
    static uint16_t ntramas_repetidas = 0;
    uint8_t buf[100];
    uint16_t chk;
    uint8_t nbytes=0;
    bool envia=true;
    uint16_t tipo=TRAMA_ESTADO_SERVO_DIR;
    
    static float rumbo = 0.0;
 
    UDPSocket sock(&net);

//****************************************
// ENVIO DE ESTADO A PANTALLAS

    nbytes = sizeof(datos_servo);
    datos_servo.n_servo = babor_estribor;

/*    
    if(datos_servo.estado == DIR_MASTER || datos_servo.estado == DIR_REPOSO)
        datos_servo.posicion_mando = desviacion_servo;
    else
        datos_servo.posicion_mando = pos_objetivo_servo;  // PARA PILOTO AUTOMATICO
*/    
    //  DEBUG_PORT.print("enviado: ");
    //  DEBUG_PORT.println(datos_servo.posicion_mando);
    
    //Comprueba si los datos han variado
    if(memcmp((void *)&datos_ant, (void *)&datos_servo, nbytes)==0 && ntramas_repetidas<10){
        envia = false;
        ntramas_repetidas++;  // cuenta tramas 
    }
    else{
        memcpy((void *)&datos_ant, (void *)&datos_servo, nbytes);
        ntramas_repetidas=0;
    }
    memcpy(&buf[4], (void *)&datos_servo, nbytes);
    
    uint8_t *p = buf;
    buf[0]=STX;
    buf[1]=nbytes+5;
    buf[2]=(byte)tipo;   // tipo de trama
    buf[3]=(byte)(tipo>>8);
    p = (p+nbytes+4);
    chk = checksum(buf, nbytes+4); 
    *p=(byte)(chk); p++;
    *p=(byte)(chk>>8); p++;
    *p=ETX;
    
    //  for(int i=0; i<nbytes+7; i++){
    //    DEBUG_PORT.print(" 0x");
    //    if(buf[i]<16)
    //      DEBUG_PORT.print("0");
    //    DEBUG_PORT.print(buf[i], HEX);
    //  }
    //  DEBUG_PORT.println();
    
    if(envia==true || ntramas_repetidas>=10){
        if(0 > sock.sendto("255.255.255.255", 6000, buf, nbytes+7)) {
            printf("Error enviando estado a monitores\r\n");
        //                return -1;
        }
        else{
//            printf("Enviado estado a monitores\r\n");            
        }
        ntramas_repetidas = 0;
            
    //    Udp.beginPacket(ip_PC, 6000);   // IP y puerto del receptor (broadcast)
    //    Udp.write(buf, nbytes+7);
    //    Udp.endPacket();
    }

    sock.close();    
}




void onUDPSocketEvent(void* buffer, size_t size) {
    printf("UDP event detected\r\n");     
}



/*****************************************************************
// RUTINA PRINCIPAL HILO ETHERNET
******************************************************************/
void udp_main() {
long contador=0;    // Contador segundos

/*
    // Open Ethernet connection
    do{
        net.disconnect();
        int j = net.set_network(IP, MASK, GATEWAY);
        printf("set IP status: %i \r\n",j);
    
        if(0 != net.connect()) {
            printf("Error connecting\r\n");
            Thread::wait(1000);     // espera de 1s
    //        return -1;
        }
    }while(net.connect() != 0);
 
    // Show the network address
    const char *ip = net.get_ip_address();
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
        
//    UDPSocket sock(&net);
    SocketAddress sockAddr;
*/

    while(1){

    /*
        if(contador%10==0){ // cada 10s
            UDPSocket sock(&net);
            led2 = 1;
            char out_buffer[] = "time";
            //            char out_buffer_2[50];
            //            int nc=0; 
            if(0 > sock.sendto("time.nist.gov", BROADCAST_PORT, out_buffer, sizeof(out_buffer))) {
                printf("Error sending data\r\n");
            //                return -1;
            }
            
            int n = sock.recvfrom(&sockAddr, &in_data, sizeof(ntp_packet));
            in_data.secs = ntohl( in_data.secs ) - 2208988800;    // 1900-1970
            newtime = true;    // nueva fecha recibida

            printf("\r\n\r\nTime Received %lu seconds since 1/01/1900 00:00 GMT\r\n", (uint32_t)in_data.secs);
            nc = sprintf(out_buffer_2, "%s", ctime(( const time_t* )&in_data.secs) );
            printf("Time = %s\r\n", out_buffer_2);
            
            printf("Time Server Address: %s Port: %d\r\n\r\n", sockAddr.get_ip_address(), sockAddr.get_port());        
    
            if(0 > sock.sendto("192.168.1.37", 6000, out_buffer_2, nc)) {
                printf("\r\nError sending data 2\r\n\r\n");
                return -1;
            }
            // Close the socket and bring down the network interface
            sock.close();
            led2 = 0;
        }
    */
        led2 = 1;
        envia_trama_estado();   // envia trama de estado        
        led2 = 0;
        Thread::wait(250);     // espera de 150ms
        contador++;        
    }
    net.disconnect();
}

