//
// RUTINAS DE COMUNICACIONES POR RS485
//

#include "declaraciones.h"

extern DigitalIn SEL0;                           // Selector 1 = BABOR/ESTRIBOR, ON=BABOR OFF=ESTRIBOR
extern DigitalOut led3;                          // LED3
extern st_datos_servo datos_servo;      // ESTRUCTURA DE VARIABLES DE ESTADO DEL SERVO DE DIRECCION
extern st_datos_servo datos_otro_servo; // ESTRUCTURA DE VARIABLES DE ESTADO DEL OTRO SERVO DE DIRECCION

extern Serial serRS485;
extern Serial pc;
extern DigitalOut RS485_DIR;
extern long t_ult_recepcion;   // guarda tiempo ultima recepción
extern volatile unsigned long tiempo_ms;    // Contador de ms
extern int servo;              // servo recibido en ultima comunicacion
extern volatile float latitud;
extern volatile float longitud;
extern volatile long fecha_hora;
extern volatile int n_satelites;
extern volatile float HDOP;
extern volatile int rumbo;
extern volatile int velocidad;  // MNPH
extern volatile int timon_babor;
extern volatile int timon_estribor;
extern volatile enEstadoDireccion estado_direccion;
extern volatile byte EstadoAnteriorServo;       //Guarda estado anterior del servo para salir de piloto-automatico o rumbo
extern volatile int retardoActualizacion;       // para no visualizar estado durante este tiempo en ms
extern volatile bool act_display;               // flag para actualizar display
extern volatile bool trama_estado_valida;
extern volatile bool trama_posicion_valida;
extern volatile bool f_actualiza_tim_trans;     // Pone flag para actualizar timones y transmision


extern int cfg_hora;  // Suma dos horas a UTC

extern Timer timer;

extern volatile bool f_rs485_busy;  // comunicacion ocupada
extern int babor_estribor;          // 0=babor 1=estribor                

extern int estado_mando;            // estado mando
extern byte pulsadores;             // Estado pulsadores del mando

extern volatile bool recibidoEstadoServo;      //Si ha recibido estado del otro servo se pone a true para sincronizacion
extern Timer timerRS485;                       // Timer para sincronizacion por rs485 de los mandos

// DEFINICION FUNCIONES
uint16_t checksum(uint8_t *buf, uint16_t nb);   // CALCULA CHECKSUM

volatile char tx_buffer[buffer_size+1];
volatile char rx_buffer[buffer_size+1];

volatile byte RS485BufIn[buffer_size+1];        // Buffer de copia de recepcion por RS485
volatile int tiempo_tx_rs485=0;


// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;

void PrintHex8(uint8_t *data, uint8_t length); // prints 8-bit data in hex with leading zeroes

long tim_envio = 0;     // tiempo en ms de envio de estado a mandos


/*
/////////////////////////////////////////////////////////
// PROCESA RECEPCION DESDE SERIAL RS485
void onSerialRxRS485(void){  // Procesa recepcion RS485

    printf("RS485:");
    while (serRS485.readable()) {
        char c = serRS485.getc();
        pc.putc(c);
    }
    printf("\r\n");
}
*/



/*
 * ENVIA ESTADO A LOS MANDOS
 */
void envia_estado_mando(void){
    
    if(f_rs485_busy)       // SI YA ESTA TRANSMITIENDO, FINALIZA
        return;

    st_trama_estado *p_trama_estado;
    p_trama_estado = (st_trama_estado *)&tx_buffer;
    memset((void *)p_trama_estado, 0x00, sizeof(st_trama_estado));
    
    p_trama_estado->bStart = STX;
    p_trama_estado->nBytes = sizeof(st_trama_estado);
    p_trama_estado->servo = babor_estribor;  // Si es servo de babor = 0
    p_trama_estado->tipo = TIPO_TRAMA_ESTADO_RS485;
    p_trama_estado->HDOP = HDOP;
    p_trama_estado->nSatelites = n_satelites;
    p_trama_estado->latitud = datos_servo.latitud;
    p_trama_estado->longitud = datos_servo.longitud;
    p_trama_estado->timeStamp = datos_servo.fecha_hora + (long)cfg_hora;  // Suma ajuste hora;
    p_trama_estado->velocidad = datos_servo.velocidad;
    p_trama_estado->rumbo = datos_servo.rumbo;
    p_trama_estado->estado = datos_servo.estado;
    p_trama_estado->timBabor = datos_servo.timon_babor;
    p_trama_estado->timEstribor = datos_servo.timon_estribor;
    p_trama_estado->posicion = datos_servo.posicion_mando;
    p_trama_estado->trim_timon_bab = datos_servo.trim_timon_bab;
    p_trama_estado->trim_trans_bab = datos_servo.trim_trans_bab;
    p_trama_estado->trim_timon_estr = datos_servo.trim_timon_estr;
    p_trama_estado->trim_trans_estr = datos_servo.trim_trans_estr;
    p_trama_estado->rumbo_fijado = datos_servo.rumbo_fijado;
    p_trama_estado->ch_radio = datos_servo.ch_radio;    
    p_trama_estado->chk = checksum( (byte *)p_trama_estado, sizeof(st_trama_estado)-3);
    p_trama_estado->bStop = ETX;
    
//    PrintHex8((uint8_t *)&tx_buffer, sizeof(st_trama_estado));
//    pc.printf("\r\n");

    RS485_DIR = 1;  // pone en TX
    tx_out = 0;
    tx_in = sizeof(st_trama_estado);
    f_rs485_busy=true;     // TRANSMITIENDO

    led3 = 1;       // enciende led INICIO DE TRANSMISION

    printf("%dms envia estado: %d\r\n", millis()-tim_envio, datos_servo.estado);
    printf("trim_timon_bab:%d trim_timon_estr:%d\r\n", datos_servo.trim_timon_bab, datos_servo.trim_timon_estr);
//    printf("%dms envia estado: %d\r\n", millis()-tim_envio, datos_servo.estado);
//    printf("est:%d pos:%d, est:%d pos:%d\r\n", datos_servo.estado, (int16_t)datos_servo.posicion_mando, datos_otro_servo.estado, (int16_t)posicion_otro_servo);

    tim_envio = millis();
}



/*
 * ENVIA POSICION DEL MANDO
 */
void envia_posicion_mando(uint16_t posicion_mando){

/*
    led3 = 1;

    st_trama_posicion trama_posicion;
    memset((void *)&trama_posicion, 0x00, sizeof(trama_posicion));
    
    trama_posicion.bStart = STX;
    trama_posicion.nBytes = sizeof(st_trama_posicion);
    trama_posicion.servo = SEL0.read();  // Si es servo de babor = 0
    trama_posicion.tipo = TIPO_TRAMA_POSICION_RS485;
    trama_posicion.posicion = posicion_mando;
    trama_posicion.estado = (int)datos_servo.estado;
    trama_posicion.chk = checksum( (byte *)&trama_posicion, sizeof(trama_posicion)-3);
    trama_posicion.bStop = ETX;
    
    //  printTrama( (byte *)&trama_posicion, sizeof(trama_posicion));
    
    uint16_t i = sizeof(trama_posicion);
    byte *p = (byte *)&trama_posicion;
     
    RS485_DIR = 1;  // pone en TX
    wait(0.1);
    while(i-->0)
        serRS485.putc(*p++);
//    serRS485.printf("PRUEBA DE COMUNICACION POR RS485\r\n");
    wait(0.1);
    RS485_DIR = 0;  // pone en RX
       
    printf("pos>> %d\r\n", trama_posicion.posicion);
    led3 = 0;
*/
}




/*
 * PROCESA TRAMA RECIBIDA DESDE EL MANDO
 */
void procesaTramaMando(st_trama_estado_mando *p)
{
static uint8_t pulsadores_old = 0;
static uint8_t rudBab_old = 0;
static uint8_t rudEst_old = 0;
static uint8_t traBab_old = 0;
static uint8_t traEst_old = 0;


    if(p->mando == babor_estribor) {  // Si es de su mando lo procesa
        datos_servo.ch_radio = p->radioCH;
        datos_servo.trim_timon_bab = p->rudBab;
        datos_servo.trim_timon_estr = p->rudEst;
        datos_servo.trim_trans_bab = p->traBab;
        datos_servo.trim_trans_estr = p->traEst;
        estado_mando = p->estado;
        pulsadores = p->pulsado;    // Estado pulsadores del mando

        if(pulsadores != pulsadores_old){
            procesa_pulsadores(pulsadores);     // Procesa segun estado de los pulsadores del mando
            pulsadores_old = pulsadores;
        }
        
        if( rudBab_old != p->rudBab ||
            rudEst_old != p->rudEst ||
            traBab_old != p->traBab ||
            traEst_old != p->traEst ){
            f_actualiza_tim_trans = true;   // Pone flag para actualizar timones y transmision
        }
        
        rudBab_old = p->rudBab;
        rudEst_old = p->rudEst;
        traBab_old = p->traBab;
        traEst_old = p->traEst;
        

//        printf("%dms estado_mando:%d\r\n", millis()-tim_envio, estado_mando);
//        printf("trim_timon_bab:%d trim_timon_estr:%d\r\n", datos_servo.trim_timon_bab, datos_servo.trim_timon_estr);

/*
        printf("pulsadores:%d\r\n", pulsadores);
        printf("%dms estado_mando:%d\r\n", millis()-tim_envio, estado_mando);
    } else {
        printf("%dms otro_mando\r\n", millis()-tim_envio);
*/
    }
}





////////////////////////////////////////////////////////
// ENVIA TEST A SALIDA RS485
void envia_test(void)
{

    RS485_DIR = 1;   // Envia
    wait(0.0005);    // espera 0.5 ms
//        serRS485.printf("LED %s\r\n", (myled)?"Encendido" : "Apagado");
    serRS485.printf("SALIDA RS485\r\n");
    wait(0.0005);    // espera 0.5 ms
    RS485_DIR = 0;   // Recibe
}




/*
 * PROCESA TRAMA RECIBIDA DESDE EL SERVO
 */
void procesaTramaServo(st_trama_estado *p)
{

//    char buf[150];

//  sprintf(buf, "Aux:%d servo:%d\r\n", (nMando), p->servo);
//  enviaRS485(buf);
    if(p->servo == babor_estribor) {  // Si es de su servo lo procesa, // 0=babor 1=estribor 
/*
        servo = p->servo;
        HDOP = p->HDOP;
        n_satelites = p->nSatelites;
        latitud = p->latitud;
        longitud = p->longitud;
        fecha_hora = p->timeStamp;
        velocidad = int(p->velocidad);
        rumbo = int(p->rumbo);
        timon_babor = p->timBabor;
        timon_estribor = p->timEstribor;
        EstadoAnteriorServo = p->estado;
*/
//        printf("%dms mismo_servo\r\n", millis()-tim_envio);


    } else { // PROCESA TRAMA DE ESTADO DEL OTRO SERVO, SI NO ESTÁ EN REPOSO Y EL SI, ACTUALIZA VALORES
/*
        if(estado_direccion == DIR_REPOSO && p->estado != DIR_REPOSO) {
            latitud = p->latitud;
            longitud = p->longitud;
            fecha_hora = p->timeStamp;
            velocidad = int(p->velocidad);
            rumbo = int(p->rumbo);
            timon_babor = p->timBabor;
            timon_estribor = p->timEstribor;
            datos_otro_servo.estado = p->estado;
        }
*/
        recibidoEstadoServo=true;               //Si ha recibido estado del otro servo está a true para sincronizacion
        timerRS485.reset();
        // Guarda datos de estado del otro servo
        datos_otro_servo.n_servo = p->servo;
        datos_otro_servo.estado = p->estado;
        datos_otro_servo.latitud = p->latitud;
        datos_otro_servo.longitud = p->longitud;
        datos_otro_servo.fecha_hora = p->timeStamp;
        datos_otro_servo.velocidad = p->velocidad;          // NUDOS
        datos_otro_servo.rumbo = p->rumbo;
        datos_otro_servo.ch_radio = p->ch_radio;
        datos_otro_servo.trim_timon_bab = p->trim_timon_bab;
        datos_otro_servo.trim_trans_bab = p->trim_trans_bab;
        datos_otro_servo.trim_timon_estr = p->trim_timon_estr;
        datos_otro_servo.trim_trans_estr = p->trim_trans_estr;
        datos_otro_servo.timon_babor = p->timBabor;        // %de timon babor bajado, para 100% 5s, 1% = 50ms
        datos_otro_servo.timon_estribor = p->timEstribor;     // %de timon estribor bajado, para 100% 5s
        datos_otro_servo.rumbo_fijado = p->rumbo_fijado;       // Rumbo fijado al pulsar botón para RUMBO FIJO
        datos_otro_servo.rumbo_piloto_auto = p->rumbo_fijado;  // Rumbo fijado por piloto automático
        datos_otro_servo.posicion_mando = p->posicion;     // Posicion actual del mando

/*        
    // SI LOS DOS EN REPOSO ACTUALIZAN CONFIGURACIONES
    if(datos_servo.estado == DIR_REPOSO && datos_otro_servo.estado == DIR_REPOSO){
        datos_servo.ch_radio = datos_otro_servo.ch_radio;
        datos_servo.trim_timon_bab = datos_otro_servo.trim_timon_bab;
        datos_servo.trim_trans_bab = datos_otro_servo.trim_trans_bab;
        datos_servo.trim_timon_estr = datos_otro_servo.trim_timon_estr;
        datos_servo.trim_trans_estr = datos_otro_servo.trim_trans_estr;
        datos_servo.rumbo_fijado = datos_otro_servo.rumbo_fijado;       // Rumbo fijado al pulsar botón para RUMBO FIJO
    }
*/


//        PrintHex8((uint8_t*)&datos_otro_servo, sizeof datos_otro_servo); // prints 8-bit data in hex with leading zeroes
        printf("\r\n%d ms otro_servo:%02X\r\n\r\n", millis()-tim_envio, datos_otro_servo.estado);
        printf("trim_timon_bab:%d trim_timon_estr:%d\r\n", datos_otro_servo.trim_timon_bab, datos_otro_servo.trim_timon_estr);
    }
}


/*
 * PROCESA TRAMA DE POSICION RECIBIDA DESDE LOS SERVOS
 */
void procesaTramaPosicion(st_trama_posicion *p)
{

    if(p->servo == babor_estribor) {  // Si es del otro servo actualiza estado del otro
        printf("%dms pos_mismo_servo\r\n", millis()-tim_envio);
    }
    else{
        datos_otro_servo.estado = p->estado;
        printf("%dms pos_otro_servo\r\n", millis()-tim_envio);
    }
}



/////////////////////////////////////////////////////////
// PROCESA RECEPCION DESDE RS485
void onSerialRxRS485(void)   // Procesa recepcion RS485 por interrupcion
{
    static uint16_t nc = 0;   // bytes recibidos
    static uint16_t nt = 0;   // bytes a recibir
    static bool inicio = false; // true si recibiendo trama

    while (serRS485.readable()) {
        char c = serRS485.getc();
//        pc.putc(c);
        t_ult_recepcion = tiempo_ms;   // guarda tiempo ultima recepción
        if(inicio == true) {  // procesa caracter
            rx_buffer[nc] = c;
            if(nc==1)
                nt = c;   // carga numero de bytes
            if(nc>0 && nc>=(nt-1)) { // final de trama
                if(c == ETX) {    // si caracter final de trama
                    uint16_t chk = ((uint16_t)rx_buffer[nt-2]*256)+rx_buffer[nt-3];
                    uint16_t chkCal = checksum((uint8_t *)rx_buffer, nt-3);
                    
//                    PrintHex8((uint8_t *)rx_buffer, nc+1); // prints 8-bit data in hex with leading zeroes
//                    pc.printf("\r\nchk=%04X ", chk);
//                    pc.printf("chkCal=%04X\r\n", chkCal);
                    
                    if(chk == chkCal) {
                        // Trama válida
                        memcpy((void *)RS485BufIn, (void *)rx_buffer, buffer_size+1);
                       
                        uint16_t tipo = RS485BufIn[2];  // Lee tipo de trama
                        if(tipo == TIPO_TRAMA_ESTADO_RS485) { // Si es trama estado del servo
//                            pc.printf("Recibido Servo %d\r\n", RS485BufIn[3]);
                            st_trama_estado *p = (st_trama_estado *)&RS485BufIn[0];
                            // Procesa estado recibido desde el servo
                            procesaTramaServo(p);
                        } else if(tipo == TIPO_TRAMA_POSICION_RS485) { // Si es trama de posicion
//                            pc.printf("Recibida Posicion Servo %d\r\n", RS485BufIn[3]);
                            st_trama_posicion *p = (st_trama_posicion *)&RS485BufIn[0];
                            // Procesa trama de posicion recibida desde los servos
                            procesaTramaPosicion(p);
                        } else if(tipo == TIPO_TRAMA_ESTADO_MANDO_RS485) { // Si es trama de estado mando
//                            pc.printf("Recibido Mando %d\r\n", RS485BufIn[3]);
                            st_trama_estado_mando *p = (st_trama_estado_mando *)&RS485BufIn[0];
                            procesaTramaMando(p);
                        }
                    }
                }
                nc = 0;
                inicio = false;   // Prepara para nueva trama
            }
            if(inicio==true)
                nc++;
        } else {
            if(c == STX) {
                nc = 1;
                inicio = true;
                rx_buffer[0] = c;
            }
        }
    }
    return;
}


//***********************************************
// RUTINA DE ENVIO DE BUFFER POR RS485
//***********************************************
void SerialTxRS485(void)
{
static int nv = 0;
static int t = 0;

    if(f_rs485_busy==true){
        if(tx_in == tx_out){    // Si ha finalizado
            wait(0.00015);
            RS485_DIR = 0;  // pone en RX, fin de transmision
            f_rs485_busy = false;   // borra flag
            led3 = 0;       // apaga led FIN TRANSMISION
//            printf("bytes:%d nv:%d\r\n", tx_out, nv);
            nv=0;
            t=0;
        }
        else{
//            serRS485.putc(tx_buffer[tx_out]);
//            tx_out++;
            while ((tx_in != tx_out) && serRS485.writeable()) {  // si el buffer está vacio y hay bytes para enviar
                serRS485.putc(tx_buffer[tx_out]);
                tx_out = (tx_out + 1);
            }
            nv++;
        }
    }
    else{
        led3 = 0;       // apaga led FIN TRANSMISION        
    }
}



/********************************************************************
// RUTINAS DE COMUNICACION POR MODBUS PARA PLCs
********************************************************************/

//    uint8_t tram_modbus[]={0x01,0x10,0x70,0x12,0x00,0x04,0x08,0x00,0x00,0x40,0x40,0xCC,0xCD,0x40,0x40}; // pone a min=4.0 (40 80 00 00), max=5.01 (40 A0 51 EC)
    uint8_t tram_modbus[]={0x0A,0x04,0x00,0x00,0x00,0x0A};  //0x71,0x76 L,H



/********************************************************************
// CALCULO DE CRC PARA TRAMA MODBUS
********************************************************************/
uint16_t crc16(uint8_t *buf, uint16_t len)
{
    uint16_t crc = 0xFFFF;

    for (int pos = 0; pos < len; pos++) {
        crc ^= (uint16_t)buf[pos];          // XOR byte into least sig. byte of crc

        for (int i = 8; i != 0; i--) {    // Loop over each bit
            if ((crc & 0x0001) != 0) {      // If the LSB is set
                crc >>= 1;                    // Shift right and XOR 0xA001
                crc ^= 0xA001;
            } else                          // Else LSB is not set
                crc >>= 1;                    // Just shift right
        }
    }
    // Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)
    return crc;
}



/********************************************************************
// TEST PARA TRAMA MODBUS
********************************************************************/
void test_modbus(void)
{
     uint16_t crc;

    crc = crc16(tram_modbus, sizeof tram_modbus);
    printf("CRC=%04X\r\n", crc);
    
}


    uint8_t MB_timones_w[]={0x01,0x10,0x70,0x12,0x00,0x04,0x08,0x00,0x00,0x40,0x40,0xD7,0x0A,0x40,0x73,0,0}; // pone a min=3.0 (40 40 00 00), max=3.8 (40 73 D7 0A)



/*******************************************************************************
 * ENVIA TRAMA MODBUS RS485
 ******************************************************************************/
void envia_trama_modbus(){

    if(f_rs485_busy)       // SI YA ESTA TRANSMITIENDO, FINALIZA
        return;
        
    if(f_actualiza_tim_trans==true || datos_servo.estado==DIR_RUMBO || datos_servo.estado == DIR_PILOTO || datos_servo.estado == DIR_MASTER){

        float hist = 0.2;
        long v_max = 8000;
        long v_min = 3000;
        
        float val_tb_min = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000);
        float val_tb_max = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000)+hist;
        float val_te_min = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000);
        float val_te_max = ((float)map(datos_servo.timon_babor, 0, 100, v_min, v_max)/1000)+hist;
    
        uint8_t *p_tb_min = (uint8_t *)&val_tb_min;
        uint8_t *p_tb_max = (uint8_t *)&val_tb_max;
        uint8_t *p_te_min = (uint8_t *)&val_te_min;
        uint8_t *p_te_max = (uint8_t *)&val_te_max;
           
        // Prepara trama para envio
        uint8_t *pb = (uint8_t *)&tx_buffer;
        memcpy(pb, MB_timones_w, sizeof MB_timones_w);
        pb += 7;  // puntero a inicio de datos
        *pb++ = p_tb_min[1];
        *pb++ = p_tb_min[0];
        *pb++ = p_tb_min[3];
        *pb++ = p_tb_min[2];
        *pb++ = p_tb_max[1];
        *pb++ = p_tb_max[0];
        *pb++ = p_tb_max[3];
        *pb++ = p_tb_max[2];
    
        uint16_t crc = crc16((uint8_t *)&tx_buffer, (sizeof MB_timones_w)-2);
        *pb++ = (uint8_t)crc;
        *pb++ = (uint8_t)(crc>>8);
    
    //    PrintHex8((uint8_t *)&tx_buffer, sizeof(st_trama_estado));
    //    pc.printf("\r\n");
    
        RS485_DIR = 1;  // pone en TX
        tx_out = 0;
        tx_in = sizeof MB_timones_w;
        f_rs485_busy = true;     // TRANSMITIENDO
    
        led3 = 1;       // enciende led INICIO DE TRANSMISION
    
    //    printf("%dms envia estado: %d\r\n", millis()-tim_envio, datos_servo.estado);
    //    printf("est:%d pos:%d, est:%d pos:%d\r\n", datos_servo.estado, (int16_t)datos_servo.posicion_mando, datos_otro_servo.estado, (int16_t)posicion_otro_servo);
    
        tim_envio = millis();
        f_actualiza_tim_trans = false;     // borra flag para actualizar timones y transmision
    }  
}

