
#include "declaraciones.h"


extern Serial pc;
extern volatile byte estado;




//***************************************************************
// * DEVUELVE VALOR DENTRO DEL LIMITE
//***************************************************************
long constrain(long valor, long minimo, long maximo){

    return (valor < minimo)? minimo : ((valor > maximo)? maximo : valor);
}


//***************************************************************
// * EXTRAPOLA VALOR EN UN RANGO
//***************************************************************
long map(long valor, long minimo_in, long maximo_in, long minimo_out, long maximo_out){

    long val = (valor < minimo_in)? minimo_in : ((valor > maximo_in)? maximo_in : valor);

    float dif_in = (float)maximo_in - (float)minimo_in;
    float dif_out = (float)maximo_out - (float)minimo_out;
    float conv = dif_out/dif_in;
    val = (long)(((float)val * conv)+0.5) + minimo_out;
    return val;
}



void PrintValorDecimal(char *txt, int32_t valor){
    pc.printf("%s: %d\r\n", txt, valor);
}


void PrintValorFloat(char *txt, float valor){
    pc.printf("%s: %f\r\n", txt, valor);
}



void PrintHex8(uint8_t *data, uint8_t length) // prints 8-bit data in hex with leading zeroes
{
       for (int i=0; i<length; i++) {
           pc.printf("0x%02x ", data[i]);
       }
}




// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// devuelve grados
void grados(float pos, int res[]){  // devuelve grados
  
  res[0] = int(pos);
  pos -= res[0];
  pos *= 60;
  res[1] = int(pos);
  pos -= res[1];
  pos *= 60;
  res[2] = int(pos);
}



/*
 * CALCULA CHECKSUM
 */
uint16_t checksum(uint8_t *buf, uint16_t nb){
  uint16_t chk=0;

  for(uint8_t i=0; i<nb; i++){
    chk += buf[i];
  }
  chk ^= 0xffff;
  return chk;
}
