#include "mbed.h"
#include "rtos.h"
#include "MPU6050.h"
#include "FastPWM.h"
#include "codeurs.h"

Codeurs codeurs;

// déclaration des objets
Serial pc(USBTX, USBRX,38400);//Autorisation liaison série entre nucleo et le PC
Serial hc(D1, D0,230400);      //P9 et P10 sont les broches RX et TX, et il sont
DigitalOut led(LED1);
MPU6050 module(I2C_SDA, I2C_SCL); //Initialisation du MPU6050

//Sortie PWM
FastPWM PWM1Droit(D9);
FastPWM PWM2Droit(D10);
FastPWM PWM1Gauche(D11);
FastPWM PWM2Gauche(D12);

// valeur de Te
float tems = 10;

//Variable Codeur
int G, D;
float Gp=0, Dp=0;
float variationG, variationD;
float vitesseG, vitesseD;
float vitesseMoyObs, vitesseMoyObsp;

//Variable BT
char data;
float rotation, intensite=3;

// variable necessaire à la mesure de la position angulaire du gyropode
float accelero[3]= {0};
float gyro[3] = {0};

//Signal de commande
double alphaCom,angleCom;

//Variable de consigne
float angleStable=-0.07;
float angleGyroCons;
float alphaMoyCons;

//Variable Observé
float vitesseGyroObs;
float angleGyroObs;

//Filtre complémentaire
float aFC, bFC;         // les coefficient du filtre passe bas du filtre complémentaire
float tauFC = 0.2;        // constante de tyemps en seconde du filtre passe bas du filtre complémentaire
//Variable de calcul du filtre complémentaire
float angleATG, angleNF;
float omegarGyro;
float angleGyroObsp;

//Correcteurs 3
float kpPosition = 2.46, kdPosition=0.337; // Correcteur PI Asservissement de Position
float kpVitesse=0.1, kdVitesse=0, kiVitesse=0;;         // Correcteur P Asservissement de Vitesse

//Erreurs
float erreurAp, erreurAv;
float sommeErreur;

int nbInc=0;
char flagInterupt=0;

void reception(char data)
{
    pc.putc(data);

    switch (data) {

        case '0':    //PAD non appuye

            alphaMoyCons=0;
            rotation=0;
            break;

        case '1':    // PAD AVANT

            alphaMoyCons=3;
            break;

        case '2':    // PAD DROIT

            rotation =-0.1;
            break;

        case '3':    // PAD AVANT

            alphaMoyCons=-3;
            break;

        case '4':    // PAD GAUCHE

            rotation=0.1;
            break;

        case 'A':    // UTILISATION SLIDER

            intensite=data;
            if (data=='S');
            break;

        case 'C':    // MARCHE
            //Retour des coefficients à leur valeur 
            kpPosition = 2.46;
            kdPosition=0.337; // Correcteur PI Asservissement de Position
            kpVitesse=0.1;
            break;

        case 'c':    // ARRET
            //Mise à zero de tous les coefficients
            kpPosition = 0;
            kdPosition = 0; 
            kpVitesse = 0;
            break;

        default:
            break;

    }

}

void interupt()
{
    nbInc++;

    //lecture des données de l'accéléro et du gyro
    module.getAccelero(accelero);
    module.getGyro(gyro);
    codeurs.read(G,D);

    //Calcul Vitesse Gyro avec les codeurs
    variationG=Gp-(float)G;
    variationD=Dp+(float)D;
    vitesseG=variationG/tems;
    vitesseD=variationD/tems;
    vitesseMoyObs =-(vitesseG+vitesseD)/2;
    Gp=(float)G;
    Dp=(float)-D;

    ///////////////////////////////////////////////////////////////////////////////////////////////////
    /*                              FILTRE COMPLEMENTAIRE                                            */
    ///////////////////////////////////////////////////////////////////////////////////////////////////

    // Mesure position angulaire du gyro
    angleATG = atan2(accelero[1],accelero[0]);//Calcul de l'angle avec l'arctangente
    omegarGyro = - gyro[2];                   //Mesure de la vitesse du gyro

    //Calcul de la sortie du filtre complémentaire
    angleNF = angleATG + tauFC * omegarGyro;
    angleGyroObs = aFC*( angleNF + bFC * angleGyroObsp);
    angleGyroObsp=angleGyroObs;

    ///////////////////////////////////////////////////////////////////////////////////////////////////
    /*                        ASSERVISSEMENT DE POSITION ANGULAIRE                                   */
    ///////////////////////////////////////////////////////////////////////////////////////////////////

    //Définir la consigne de l'asservissement de position angualaire
    angleGyroCons = angleStable+angleCom;

    //calcul de la grandeur de commande de l'asservissement de position angulaire
    erreurAp = angleGyroCons-angleGyroObs;                //calcul de l'erreur
    alphaCom= kpPosition*erreurAp- kdPosition*omegarGyro; //Calcul de la sortie du proportionelle-dérivée

    ///////////////////////////////////////////////////////////////////////////////////////////////////
    /*                               ASSERVISSEMENT DE VITESSE                                       */
    ///////////////////////////////////////////////////////////////////////////////////////////////////

    //Calcul de la grandeur de commande de l'asservissement de vitesse
    erreurAv=alphaMoyCons-vitesseMoyObs;
    sommeErreur = sommeErreur+erreurAv;
    angleCom=kpVitesse*erreurAv-kdVitesse*((vitesseMoyObs-vitesseMoyObsp)/(tems/1000))+kiVitesse*sommeErreur*(tems/1000);
    vitesseMoyObsp=vitesseMoyObs;


    //compensation frottement sec
    if (alphaCom>0) {
        alphaCom+=0.1;
    }

    if (alphaCom<0) {
        alphaCom-=0.1;
    }

    //Saturation de alphaCom
    if (alphaCom>0.5) {
        alphaCom=0.5;
    } else if (alphaCom<-0.5) {
        alphaCom=-0.5;
    }


    // Sortie de PWM moteur
    PWM1Droit.write(0.5+alphaCom-rotation);
    PWM2Droit.write(0.5-alphaCom+rotation);
    PWM1Gauche.write(0.5-alphaCom-rotation);
    PWM2Gauche.write(0.5+alphaCom+rotation);

    flagInterupt=1;
}

RtosTimer timer(mbed::callback(interupt),osTimerPeriodic);

int main()
{
    pc.printf("Test unitaire mecatro \n\r");

//Init Mot
    PWM1Droit.period_us(50);
    PWM2Droit.period_us(50);
    PWM1Gauche.period_us(50);
    PWM2Gauche.period_us(50);


// initialisation et test de connection du MPU6050
    while (module.testConnection()==0) {
        pc.printf("not connected to mpu\n\r");
        wait(1);
    }
    //changement du l'echelle du module
    module.setGyroRange(MPU6050_GYRO_RANGE_2000);
    module.setAcceleroRange(MPU6050_ACCELERO_RANGE_2G);

    // calcul des coefficients des filtres
    aFC=(float)1/(1+tauFC/(tems/1000));
    bFC=tauFC/(tems/1000);


    //initialisation de la la tache periodique du noyau multitache
    timer.start(tems);


    codeurs.reset();
    while(1) {

        if (hc.readable()) {    //xx.readable() = Test si xx envoie des valeurs
            data=hc.getc();
            reception(data);

        }
        if (flagInterupt==1) {
            flagInterupt=0;
        }
    }
}