#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "Adafruit_GFX.h"

//Configuracion OLED
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};
I2C gI2C(PB_9,PB_8);
//I2C i2c(PB_9, PB_8);
Adafruit_SSD1306_I2c Oled(gI2C,D2);
// 

int pct, PD=0;

AnalogIn pot(A0); //Potenciometro Analogo

DigitalOut CS(D1);  //Pines del PD
DigitalOut UD(D2);
DigitalOut INC(D3);

Thread hilo_cero;
Thread hilo_mover;
Thread hilo_porcentaje;

void cero(void);  //Llevar el PD a la posicion cero
void mover(void);  //Mover el PD, compara el valor actual y el nuevo valor
int porcentaje(void);  //Convierte el PA en un valor porcentual (0-100)

int main()
{
 hilo_cero.start(cero);
 hilo_mover.start(mover);
 hilo_porcentaje.start(porcentaje);

 Oled.begin();
 Oled.display();
 ThisThread::sleep_for(3000ms);
 Oled.clearDisplay();
 Oled.display();

 cero();
    while (true) {
       pct = porcentaje();
       mover();
       ThisThread::sleep_for(198ms);
       PD=pct;
        Oled.setTextCursor(1, 1);
        Oled.setTextColor(1);
        Oled.setTextSize(1);
        Oled.printf("Valor del PD: %5u", PD);
        Oled.display();
                 }
}

void cero(void) {     // Dejar en 0 el potenciometro
   CS = 1;
   INC = 1;

   CS = 0;
   wait_us(1);
   UD = 0;
   for (int n=0; n<100; n++){
            INC = 0;
            wait_us (1);
            INC=1;
            wait_us (1);
            
                       }

        INC = 1; 
        wait_us (1);
        CS = 1;
}

void mover(void) { //Valor del PA, Valor actual del PD  y comparar
        
        int d=0;
        if (pct>PD){ 
        d = pct-PD;           
        UD = 1;
        CS = 0;
        wait_us (1);
        for (int o=0; o<d; o++){
            INC = 0;
            wait_us (1);
            INC=1;
            wait_us (1);
                            }
        INC = 1; 
        wait_us (1);
        CS = 1;
                }
        
        if (pct<PD){ 
        d = PD-pct;
        UD = 0;
        CS = 0;
        wait_us (1);
        for (int o=0; o<d; o++){
            INC = 0;
            wait_us (1);
            INC=1;
            wait_us (1);
                            }
        INC = 1; 
        wait_us (1);
        CS = 1;
               }

        Oled.setTextCursor(1, 40);
        Oled.setTextColor(1);
        Oled.setTextSize(1);
        Oled.printf("Pasos del PD: %u", d);
        Oled.display();
}

int porcentaje(void){
    int p, v=0;
    v = pot*3.3;
    p = (v*100)/3.3;
    return p;
                    }