    
#pragma pack(1)  //this forces the structure to be packed on byte boundaries (with no byte filler)
//set up the GPS message header in a structure to enable easy reading -- see the OEM615 manual (Table 4, page 24)
struct MESSAGEHEADER   
{
    char synchAA;  //1st synch word
    char synch44;  //2nd synch word
    char synch12;  //3rd synch word
    unsigned char headerLength;  //always 28
    unsigned short messageID;
    char messageType;  //always = 0 for binary
    unsigned char portAddress;  //0x20 for COM1
    unsigned short messageLength; //not including header or CRC
    unsigned short sequence;  //typically 0
    unsigned char idleTime;  //Time the processor is idle, in the last second
    unsigned char timeStatus; //Enum Indicating quality of the GPS reference time
    unsigned short GPSweek;   //GPS reference week
    unsigned long GPSTime_msecs; //from beginning of week
    unsigned long receiverStatus; //32-bits representing the status of hardware and software
    unsigned short reserved;
    unsigned short receiverSWversion;  //receiver software build number
};
MESSAGEHEADER *msgHeader[4];

#pragma pack(1)
//structure for OEM615 BESTVEL log message  (page 314)
struct OEM615BESTVEL
{
    MESSAGEHEADER msgHeader;
    int solStatus;                      //solution status
    //solutionStatusOEMStar solStatus;  //solution status
    int velType;                        //position or velocity type
    //velTypeOEMStar posType;           //position or velocity type   
    float latency;
    float age;
    double horizontalSpeed;         //horizontal velocity vector magnitude (m/s)
    double heading;                 //deg from North called TRK GND in specification
    double verticalSpeed;           //vertical velocity magnitude (m/s)
    float reserved;
    unsigned long CRC;
};

#pragma pack(1)
//structure for BESTPOS message 
struct OEM615BESTPOS
{
    MESSAGEHEADER msgHeader;
    int solStatus;                      //solution status
    //solutionStatusOEMStar solStatus;  //solution status
    int posType;                        //position or velocity type
    //posTypeOEMStar posType;           //position or velocity type
    double latitude;                    //latitude
    double longitude;                   //longitude
    double height;                      //height above mean sea level
    float undulation;                   //the realtionship between the geoid and the
                                        //ellipsoid of the chosen datum (m)
    char datumID[4];                    //datum ID is actually an enum that is not implemented
    float latitudeSTD;                  //latitude standard deviation
    float longitudeSTD;                 //longitude standard deviation
    float heightSTD;                    //height standard deviation
    char baseStationID[4];              //base station ID
    float diffAge;                      //differential age (s)
    float solutionAge;                  //solution age (s)
    unsigned char numSV;                //number of satellite vehicles tracked
    unsigned char numSolSV;             //number of satellite vehicles used in solution
    unsigned char numGGL1;              //number of GPS plus Glonass L1
    unsigned char res1;
    unsigned char res2;
    unsigned char extSolStatus;         //extended solution status
    unsigned char res3;
    unsigned char sigMask;              //signals used mask
    unsigned long CRC;
};


//this code was taken from the Novatel Firmware document page 35
#define CRC32_POLYNOMIAL 0xEDB88320L
/* --------------------------------------------------------------------------
Calculate a CRC value to be used by CRC calculation functions.
-------------------------------------------------------------------------- */
unsigned long CRC32Value(int i)
{
    int j;
    unsigned long ulCRC;
    ulCRC = i;
    for ( j = 8 ; j > 0; j-- )
    {
        if ( ulCRC & 1 )
        ulCRC = ( ulCRC >> 1 ) ^ CRC32_POLYNOMIAL;
        else
        ulCRC >>= 1;
    }
    return ulCRC;
} 

/* --------------------------------------------------------------------------
Calculates the CRC-32 of a block of data all at once
//the CRC is c from the complete message (header plus data) but excluding (of course) the CRC at the end
-------------------------------------------------------------------------- */
unsigned long CalculateBlockCRC32(
        unsigned long ulCount,    /* Number of bytes in the data block */
        unsigned char *ucBuffer ) /* Data block */
{
    unsigned long ulTemp1;
    unsigned long ulTemp2;
    unsigned long ulCRC = 0;
    while ( ulCount-- != 0 )
    {
        ulTemp1 = ( ulCRC >> 8 ) & 0x00FFFFFFL;
        ulTemp2 = CRC32Value( ((int) ulCRC ^ *ucBuffer++ ) & 0xff );
        ulCRC = ulTemp1 ^ ulTemp2;
    }
    return( ulCRC );
}

//GPS-specific pins
DigitalOut GPS_Reset(p18);      //GPS RESET line
InterruptIn PPSInt(p15);        // GPS 1PPS (timemark) from the OEM615
InterruptIn IMUClock(p17);

Timer timeFromPPS;
unsigned long GPSTimemsecs = 0;
double GPSTime = 0;
int PPSTimeOffset = 0;

//mbed tx/rx interface to the GPS COM1 port
MODSERIAL GPS_COM1(p9,p10);  //this serial port communicates with the GPS receiver serial port (COM1)



