#include "mbed.h"
#include "ts.h"
#include "display.h"
#include "adc.h"

void initialize_app(void)
{
    display_splash_screen();
    wait(2);
    
    uint32_t display_size_x, display_size_y;
    display_get_size(display_size_x, display_size_y);
    
    bool success = ts_init(display_size_x, display_size_y);

    if (!success) {
        display_failed_ts_init();   
        while(true) {;}
    }
}


int main()
{
    initialize_app();
    display_main_screen();
    
    while (1) {
        
    }
}
