#include "LCD_DISCO_F429ZI.h"

static LCD_DISCO_F429ZI lcd;

struct Rect {
    uint32_t x;
    uint32_t y;
    uint32_t height;
    uint32_t width;    
};

void display_failed_ts_init() {
    BSP_LCD_SetFont(&Font20);
    
    lcd.Clear(LCD_COLOR_RED);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
}

void display_splash_screen() {
    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"POWER", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"TIME", CENTER_MODE);
}

void display_debug_info(char *debug_text) {
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)debug_text, CENTER_MODE);
}

void display_main_screen() {
    lcd.Clear(LCD_COLOR_WHITE);
    
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(79, 82, 100, 100); //(x, y, height, width)
    
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font24);
    lcd.DisplayStringAt(10, LINE(5), (uint8_t *)"START", CENTER_MODE);
}

void display_get_size(uint32_t &x, uint32_t &y) {
    x = lcd.GetXSize();
    y = lcd.GetYSize();
}
