#include "mbed.h"
#include <stdio.h>
#include <string.h>

BusIn joy(p15,p12,p13,p16); //Initialize joystick bus
//Initialize Potentiaometers
AnalogIn pot1(p19);
AnalogIn pot2(p20);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
Serial xbeeOut(p9, p10);    //tx, rx via Xbee socket


int main()
{

    float waitTime;     //Hold random time delay
    float min = 0.05;    //Define minimum time
    float max = 0.2;   //Define maximumtime

    while(1) {
        //Serial number identifies which mbed it is transmitting
        int serial_no = 1;
        //This can be customized to take any other internal or external sensors
        int joystick = joy;
        float Lpot = pot1;
        float Rpot = pot2;
        //Echo locally for error checking
        printf("$APPBOARD,%.02f,%.02f,%d,%d %f\r\n",Lpot,Rpot,joystick,serial_no,waitTime);
        //Use the same serial fictions as above the transmit over XBee
        xbeeOut.printf("$APPBOARD,%.02f,%.02f,%d,%d\r\n",Lpot,Rpot,joystick,serial_no);
        //Wait the calculated randomized time
        if(pot1 > .5) {
            waitTime = min + ((float)rand()/RAND_MAX) * (max - min);
            wait(waitTime);
        }

    }
}
