// Example of parsing the serial string from the fullAppBaordSend
/* Code derived from the work of Joe Bradshaw:
                                            http://developer.mbed.org/users/jebradshaw/ */
/******************Declaration of necessary libraries and objects************************/
#include "mbed.h"
#include "C12832_lcd.h"     // Include for LCD code
/******************Declaration of necessary variables***********************************/
DigitalOut myled(LED1);     //For LED
Serial pc(USBTX, USBRX);    //tx, rx via USB connection
Serial xbee(p9, p10);       //tx, rx via Xbee socket
C12832_LCD lcd;                         // Decalre LCD screen
LocalFileSystem local("local");         // Create the local filesystem under the name "local"
float totalTime = 0.0;      //Total time used to calulate average wait time
float avgTime = 0.0;        //Average time when error detected
int errors = 0;             //Number of errors
int total = 0;              //Total number of transmissisons
float pctErr = 0.0;         //Percent of transmissions in error
void keepAverage(float newNum);         //Prototype for funciton to make calculations

int main()
{
    char abstr[25];    //used to store the whole app board string
    int joystick;       //int value correspponding to the joystick bus
    float Lpot;         //float correspionding to left potentiometer
    float Rpot;         //float correspionding to right potentiometer
    int id;
    pc.baud(9600);    //crank up the PC baudrate (USB) to avoid latency between data acquisition
    //xbee.baud(9600);
    //Setup LCD screen
    lcd.cls();
    lcd.locate(0,1);
    //Set up timers for transmission information
    Timer t1;
    Timer t2;
    //Start timers
    t1.start();
    t2.start();
    while(1) {
        while(xbee.readable())          //clear out the remaining characters in the buffer
            char c = xbee.getc();
        //read the serial string from the xbee (starts with '$', ends with \r\n
        xbee.scanf("$%s\r\n", &abstr);
        //Verify that the string has the APPBOARD header
        if(strncmp(abstr, "APPBOARD", 9)) { 
            //Verify the tring was able to be parsed
            if (sscanf(abstr, "APPBOARD,%f,%f,%d,%d",&Lpot,&Rpot,&joystick,&id) >= 1) {
                //Check which input the transmission came from an act accordingly
                if (id==0) {
                    //Read time and report how long it has been since node was pooled
                    if(t2.read() > 1) {
                        //If time is more than 1 second consider it an error
                        //Run the analysis program
                        keepAverage(t2.read());
                    }
                    //Reset time
                    t2.reset();
                    //Print information to LCD screen
                    lcd.locate(0,1);
                    lcd.printf("M%d: L:%.02f R:%.02f J:%d %.02f\r\n",id,Lpot,Rpot,joystick,t1.read());
                }
                if (id==1) {
                    if(t1.read() > 1) {
                        keepAverage(t1.read());
                    }
                    t1.reset();
                    lcd.locate(0,14);
                    lcd.printf("M%d: L:%.02f R:%.02f J:%d %.02f\r\n",id,Lpot,Rpot,joystick,t2.read());
                }
                //Print values to screen
                pc.printf("Mbed %d: L-%.02f:L R-%.02f Joystick:%d\r\n",id,Lpot,Rpot,joystick);
            } else {
                //Incorrect parse
                pc.printf("BAD parse %s\r\n", abstr);
            }
        }
        //Increment total
        total+=1;
        myled = !myled; //toggle LED for activity verification

    }//while(1)
}//main

void keepAverage(float newNum)
{
    Timer t3;
    t3.start();
    errors ++;
    totalTime += newNum;
    avgTime = totalTime/(float)errors;
    pctErr = (float)errors/(float)total;
    pc.printf("overNum:%f avgErrTime:%.04f totalErrs:%d totalOut:%d pctErr:%.02f\r\n", newNum,avgTime,errors,total,pctErr);
    FILE *fp = fopen("/local/out.csv", "a");  // Open "out.txt" on the local file system for writing
    fprintf(fp,"%f,%.04f,%d,%d,%.02f,%.02f\r\n", newNum,avgTime,errors,total,pctErr,t3.read());
    fclose(fp);
}