#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code
//For string maniputlation
#include <string> 
#include <sstream>
#include <stdlib.h> //Include for atoi

xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen
BusOut leds(LED1,LED2,LED3,LED4);

//Code to send strings acsross xbee with xbee.h
//Code should be on the End Device 
int main()
{
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    
    //Establish a variable to receive data from End Device
    //Max buffer is 202
    char receiveData[5];
    char clean[4]; 
    //Setup LCD screen
    lcd.cls();      
    lcd.locate(0,1);
    
    while(1) {
        //Recieve data from Xbee
        //Second argument is how many characters to read
        //If zero it will read sizeof(firstArg)
        xbee1.RecieveData(receiveData,5);
        
        //Clean data by removing leader R with String manipulation
        strncpy ( clean, receiveData+2, 3);

        //Change value back to floats for possible use later
        int inches = atoi (clean);
        
        //If something is closer than 2ft illumiate BUS leds
        if(inches < 24){
            leds = 0xFFFF;
            }
        else{leds = 0;}
        //Echo Locally...
        pc.printf("Inches: %d\n", inches);
        lcd.printf("Inches %d\n", inches);
    }
}