#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code

xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen

//Code to send strings acsross xbee with xbee.h
//Code should be on the End Device 
int main()
{
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    
    //Establish a variable to receive data from End Device
    //Max buffer is 202
    char receiveData[4]; 
    
    //Setup LCD screen
    lcd.cls();      
    lcd.locate(0,1);
    
    while(1) {
        //Recieve data from Xbee
        //Second argument is how many characters to read
        //If zero it will read sizeof(firstArg)
        xbee1.RecieveData(receiveData,0);
        
        //Echo Locally...
        pc.printf("Recieved: %s\n", receiveData);
        lcd.printf("Recieved %s \n", receiveData);
    }
}