//Pins for xbee on appBord found on back
//tx = p9
//rx = p10
//status = p29
//reset = p30

//Code to send and recieve serial comms on 
//mbed appBoard with xbees
#include "mbed.h"
#include "C12832_lcd.h" // Include for LCD code

//Initialize xbee
Serial xbee(p9, p10);
DigitalOut rst1(p30);

//Initialize terminal
Serial pc(USBTX, USBRX);

//Initialize lcd
C12832_LCD lcd;
 
int main() {
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    //Setup LCD screen
    lcd.cls();                                          //...they want to see which parameters they want to edit
    lcd.locate(0,1);
    while(1) {
        //variable to get data from xbee
        char toPrint;
        
        //If terminal data available send through xbee
        if(pc.readable()) {
            xbee.putc(pc.getc());
        }
        //If xbee gets data send to terminal and lcd screen
        if(xbee.readable()) {
            toPrint = xbee.getc();
            pc.putc(toPrint);
            lcd.printf("%c",toPrint);
        }
    }
}