#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code
#include <stdio.h> //Include for sprintf

xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen 


//Initialize Potentiaometers 
AnalogIn pot1(p19); 
AnalogIn pot2(p20); 
int main()
{
    char send_data1[202]; //Xbee buffer size is 202 bytes
    
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);

    //Give time for other Xbee to come online
    wait(1);
    
    while(1) {
        //Set up LCD and print
        lcd.cls(); 
        lcd.locate(0,2);
        lcd.printf("Pot 1 = %.2f", (float)pot1);
        lcd.locate(0,14);
        lcd.printf("Pot 2 = %.2f", (float)pot2);
        
        wait(0.1);

        //In AT mode we are constantly transmitting so it is 
        //necessary to implement an external protocol 
        //see https://developer.mbed.org/users/dannellyz/notebook/at-vs-api-when-why-how/# 
        
        //Format is aPOT1bPOT2 to send 
        sprintf (send_data1, "a%.2fb%.2f", (float)pot1,(float)pot2);
        xbee1.SendData(send_data1); //Send data to XBee
        
        
    }
}
