#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code
#include <string.h> //Iclude for string handeling
xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen
PwmOut speaker(p26); //Speaker with PWM driver
//RGB LED with 3 PWM outputs for dimmer control
PwmOut r(p23); 
PwmOut g(p24);
PwmOut b(p25);

int main()
{
    //In AT mode we are constantly transmitting so it is 
    //necessary to implement an external protocol 
    //see https://developer.mbed.org/users/dannellyz/notebook/at-vs-api-when-why-how/# 
    
    //For this we will use two buffers one for each 
    //expected reading from the appBoard pot1/pot2
    char readData1[202]; //Xbee buffer size is 202 bytes
    char readData2[202]; //Xbee buffer size is 202 bytes

    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    
    //Setup LCD screen
    lcd.cls();      
    lcd.locate(0,1);
    
    //Setup speaker
    speaker.period(1.0/800.0); // 800hz period
    
    //Setup RGB
    r=1.0;
    g=1.0;
    b=1.0;
    
    
    while(1) {
        
        //RecieveDataChar allows you to read data in until the
        //seperator which is the second argument
        
        //Recieve data format POT2a
        xbee1.RecieveDataChar(readData1,'a'); //Read data from the XBee
        //Recieve data format POT1b
        xbee1.RecieveDataChar(readData2,'b'); //Read data from the XBee
        //Needed to keep in sync with other xbee
        wait(0.1);
        
        //Clean data by removing delimeter
        readData1[strlen(readData1)-1] = 0;
        readData2[strlen(readData2)-1] = 0;
        
        //Change values back to floats for possible use later
        float pot1 = atof(readData2);
        float pot2 = atof(readData1);
        
        
        //Change red value with pot1 
        r = 1- pot1;
        //Change blue value with pot2
        b = 1- pot2; 
        
        //Echo data 
        pc.printf("Pot1= %.2f Pot2= %.2f \n\r",pot1,pot2);
        lcd.printf("Pot1= %.2f Pot2= %.2f \n\r",pot1,pot2);
    }
}

