// Example of parsing the serial string from the fullAppBaordSend
/* Code derived from the work of Joe Bradshaw: 
                                            http://developer.mbed.org/users/jebradshaw/ */
/******************Declaration of necessary libraries and objects************************/  
#include "mbed.h"
DigitalOut myled(LED1);     //LED to show functionality
Serial pc(USBTX, USBRX);    //tx, rx via USB connection
Serial xbee(p9, p10);       //tx, rx via Xbee socket
int main() {
/******************Establishment of Vaiables*********************************************/
    char abstr[25];     //used to store the whole app board string
    int joystick;       //int value corresponding to the joystick bus
    float Lpot;         //float corresponding to left potentiometer
    float Rpot;         //float corresponding to right potentiometer
/******************While loop call to run code indefinitely******************************/
    while(1) {       
        //clear out the remaining characters in the buffer     
        while(xbee.readable())      
            char c = xbee.getc();  
        //read the serial string from the xbee (starts with '$', ends with \r\n            
        xbee.scanf("$%s\r\n", &abstr);    
        //Verify that the string has the APPBOARD header
        if(strncmp(abstr, "APPBOARD", 9)){
            //Verify the tring was able to be parsed
            if (sscanf(abstr, "APPBOARD,%f,%f,%d",&Lpot,&Rpot,&joystick) >= 1) {
                //Print values to screen
                pc.printf("Mbed: L-%.02f: R-%.02f Joystick:%d\r\n",Lpot,Rpot,joystick);}
            //Incorrect parse
            else{pc.printf("BAD parse %s\r\n", abstr);}
            }//if(sscanf 
        myled = !myled; //toggle LED for activity verification   
    }//while(1)
}//main
