/*! 
Class to use the NeoPixels on an mbed with ease
 */
#include "mbed.h"
#include "neopixel.h"

/** Interface to work with Adafruit NeoPixel lights */
class easyNeo
{
private:
    int numLeds;
public:
    /**Configure simple with the number of lights in the series*/
    easyNeo(int numLeds);

    /** Will go through a test of all colors at all intensity levels
        to ensure proper operation.
      */
    void lightTest();
    
    /** Set the colors of the lights with a continuous hex string
        String should have 6 hex characters for each light corresponding 
        to their R,G and then B vlues you wish to set.
        Ex: FF000000FF000000FF would set a string of three lights to Red, Green, 
        and then Blue respectivly at the highest intensity for each.
      * @param hexString above mentioned string.
      */
    void setByHex(char*);
    
    /** Clear all formatting on NeoPix. Good to use before trying to
        set new values.
      */
    void clear();
    
    void setPixel(neopixel::Pixel * buffer, uint32_t, uint8_t, uint8_t, uint8_t, uint32_t);
    void setByColor(int ledNum, char* color);
    void update(neopixel::Pixel * buffer);
    uint8_t c2i(char );
};