#include "mbed.h"
#include "neopixel.h"
#include "easyNeo.h"
#define DATA_PIN p5

easyNeo::easyNeo(int leds)
{
    numLeds = leds;
    
}
uint8_t easyNeo::c2i(char c)
{
    if( c >= '0' && c <= '9' ) return c-'0';
    if( c >= 'A' && c <= 'F' ) return c-'A'+10;
    if( c >= 'a' && c <= 'f' ) return c-'a'+10;
    return 0;
}

void easyNeo::setPixel(neopixel::Pixel * buffer, uint32_t index, uint8_t red, uint8_t green, uint8_t blue, uint32_t length)
{
    if (index >= length ) {
        return;
    }
    buffer[index].red = red;
    buffer[index].green = green;
    buffer[index].blue = blue;
}

    
void easyNeo::setByHex(char* hexString){
    
    DigitalIn(DATA_PIN, PullDown);

    // The pixel array control class.
    neopixel::PixelArray array(DATA_PIN);

    // 8 is the number of pixels
    neopixel::Pixel buffer[numLeds];
    Serial pc(USBTX, USBRX); //Initalise PC serial comms
    int i,j,k,l;
        for(i=0, l = 0; i < (6*numLeds); i+=6,l ++){
            //pc.printf("val of i %d\n",i);
            int vals[3] = {0,0,0};
            for(k=i,j=0; k < i+6; k+=2,j++){
                //pc.printf("Index: %d  %d\n",k,k+1);
                //pc.printf("Characters: %c  %c\n",hexString[k],hexString[k+1]);
                //pc.printf("Value: %d\n",(c2i(hexString[k])*16+c2i(hexString[k+1])));
                vals[j] = (c2i(hexString[k])*16 + c2i(hexString[k+1]));
                }
            pc.printf("%d %d %d \n",vals[0],vals[1],vals[2]);
            easyNeo::setPixel(buffer, l, vals[0], vals[1], vals[2], numLeds);
            }
    
    array.update(buffer, numLeds);
    
    }
    
    
void easyNeo::clear(){

    for (int i = 0; i< numLeds; i = i++) {
        easyNeo::setByHex("000000");
        }
    }
    
void easyNeo::update(neopixel::Pixel * buffer){

    DigitalIn(DATA_PIN, PullDown);

    // The pixel array control class.
    neopixel::PixelArray array(DATA_PIN);
    
    array.update(buffer, numLeds);
}
    
void easyNeo::lightTest()
{
    DigitalIn(DATA_PIN, PullDown);

    // The pixel array control class.
    neopixel::PixelArray array(DATA_PIN);

    // 8 is the number of pixels
    neopixel::Pixel buffer[numLeds];
    
    // step through three colors with the same brigtness
    uint32_t i;
    
        //Test Red
        for (i = 0x00; i<= 0xC8; i = i + 0x0A) {
            for(int k = 0; k < numLeds; k++){
                easyNeo::setPixel(buffer, k, i, 0x00, 0x00, numLeds);
                array.update(buffer, numLeds);
                wait_ms(100);
                }
            }
        //Test Blue
        for (i = 0x00; i<= 0xC8; i = i + 0x0A) {
            for(int k = 0; k < numLeds; k++){
                easyNeo::setPixel(buffer, k,0x00, i, 0x00, numLeds);
                array.update(buffer, numLeds);
                wait_ms(100);
                }
            }
        //Test Green
        for (i = 0x00; i<= 0xC8; i = i + 0x0A) {
            for(int k = 0; k < numLeds; k++){
                easyNeo::setPixel(buffer, k,0x00, 0x00, i, numLeds);
                array.update(buffer, numLeds);
                wait_ms(100);
                }
            }
}
