#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code
#include <stdio.h> //Include for sprintf

xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen 

//Initialize the joystick on the appBoard as a Bus 
BusIn joy(p15,p12,p13,p16);
//Set the button as a Digital In
DigitalIn fire(p14);

int main()
{
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    //Setup LCD screen
    lcd.cls();      
    lcd.locate(0,1);
    
    char sendData[1]; //Buffer to send value of bus

    while(1) {
        
        //Digital pin to check for button press
        int yes = 0;
        
        //If pressed send 9
        if(fire) {
            yes = 1;
            sprintf (sendData, "%d", 9);
            }
        //Else send value of the Bus
        else{
        sprintf (sendData, "%d", joy.read());
            }
            
        xbee1.SendData(sendData); //Send data to XBee
        
        //Local of value sent
        lcd.printf("Value = %s \n", sendData);
        wait(0.1);

        
        
    }
}
