#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code

xbee xbee1(p9,p10,p30); //Initalise xbee_lib varName(rx,tx,reset)
DigitalOut rst1(p30);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen

//Initialize the Bus LEDs on appBoard
BusOut leds(LED1,LED2,LED3,LED4);
int main()
{
    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    //Setup LCD screen
    lcd.cls();      
    lcd.locate(0,1);
    
    char readData[1]; //Buffer to read value of bus
    
    while(1) {
        xbee1.RecieveData(readData,0); //Read data from the XBee
        
        //Local echo in terminal
        pc.printf("Value of Bus%d \n",readData);
        
        //and on LCD
        lcd.printf("%c\n",readData[0]);
        wait(0.1);
        
        //Switch to change LEDs based on Bus value
        switch(readData[0]){
            case '0':
                leds = 0;
                break; //optional
            case '1':
                leds = 1;
                break; //optional
            case '2':
                leds = 2;
                break; //optional
            case '4':
                leds = 4;
                break; //optional
            case '8':
                leds = 8;
                break; //optional
            case '9':
                leds = 0xFFFF;
                break; //optional

}
        
    }
}