#include "mbed.h"
#include "C12832_lcd.h"  
#include "xbee.h"
C12832_LCD lcd; 
AnalogIn ain(p17);
Serial pc(USBTX, USBRX); // tx, rx
xbee xbee1(p9,p10,p30); //Initalise xbee_lib

int main() {
    float adc, volts, inches;
    int feet, in,out;
    char send_data[2]; //Xbee buffer size is 202 bytes
    
    lcd.cls(); 
    lcd.locate(0,2);
    
    while (1){
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
        inches = (volts / 0.0064) ;    // 3.3V supply: ~6.4mV per inch
        feet = (int) inches / 12;   // inches to feet (trunc)
        in = (int) inches % 12;     // remainder: in(ches)
        out = (int) inches;
        pc.printf("adc:%8.2f  %8.2fV in:%8.2f  %d'%d\"\n", 
                  adc, volts, inches, feet, in);
        
        lcd.printf("%.2fV in: %.2f send: %d\n", 
                   volts, inches,out);
         if(out < 10){sprintf (send_data, "0%d", out);}
         else{sprintf (send_data, "%d", out);}
        xbee1.SendData(send_data); //Send data to XBee
        wait(0.05);                 // ~20Hz update rate ; note we aren't
                                    // truly synchronized ...   
    }
}