/*
  UltrasonicSensor.h - drive a distance sensor- Version 1.0.0
  Copyright (c) 2018 Daniele Briguglio.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
*/

/*
  The methods are:

   UltrasonicSensor - Class for manipulating Ultrasonic Sensor

   attach(echo, trigger)  - Attaches a Ultrasonic Sensor to an i/o pin,
   default pins are D9 for echo and D8 for trigger.
 
   read()  - Read distance measured by the sensor. 
 */

#ifndef UltrasonicSensor_h
#define UltrasonicSensor_h

#include <mbed.h>

namespace mbed {
/** \addtogroup drivers */

/**
 * @note UltrasonicSensor
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "UltrasonicSensor.h"
 *
 * UltrasonicSensor sensor(D9, D8); //declare echo pin and trigger pin (echo, trigger)
 
 * int main(){
 *   sensor.begin(); //begin the ultrasonic sensor
 *   while(1) {
 *     float dist = sensor.read(); //read distance from ultrasonic sensor in cm
 *     printf("%f cm \n\r", dist);
 *     wait(0.5);
 *   }
 * }
 * @endcode
 * @ingroup drivers
 */
    
class UltrasonicSensor {

public:
    /** Create a UltrasonicSensor connection to the specified pin
     *
     *  @param pin echo pin to connect to
     *  @param pin trigger pin to connect to
     */
    UltrasonicSensor(PinName echo, PinName trigger);
    
    /** begin of reading
     *
     *  @param float set correction for the reader
     */
    void begin(float correction);
    void begin(void);
    
    /** Return the reader
     *
     *  @returns float read the distance
     */
    float read(void);
    
protected:
    void begin2(void);
    DigitalOut _trigger;
    DigitalIn  _echo;
    int distance;
    int corr;
    Timer sonar;
};
}

#endif