/*
 * StringFifo: A simple FIFO class for passing strings between threads.
 * Includes a mutex on the load end to allow different threads to
 * push strings.  Strings are delimited by null characters, both as they
 * are pushed into the FIFO and as they are stored internally.  Execution
 * yields for a pushing thread if there is not room or if another thread
 * is currently pushing data.  Execution blocks for a reading thread until
 * there is data to read.
 *
 */
#ifndef STRING_FIFO_H
#define STRING_FIFO_H

#include "mbed.h"
 
class StringFifo {
    public:
        StringFifo(int size = 1024);
        ~StringFifo();
        
        void PushString(char* s);
        inline bool IsEmpty() {return pushI == popI;}
        void PopString(char* s);
     
    private:
        // Methods
        int Remaining();
        
        // Variables
        char* sP;
        int len;
        int pushI;
        int popI;
        Mutex push_mutex;
};
 
#endif