#include "mbed.h"
#include "rtos.h"
#include "TCS34725.h"
#include "MBed_Adafruit_GPS.h"
#include "Datas.h"


Serial pc(USBTX, USBRX, 115200); //115200 bauds
DigitalOut ledR(PH_0);// //RGB led - red light
DigitalOut ledG(PH_1);  //RGB led - green light
DigitalOut ledB(PB_13);  //RGB led - blue light
Serial gps(PA_9,PA_10);//
extern AnalogIn soil_moist; //Analog soil moisture sensor
extern AnalogIn light_sensor; //Analog light sensor
extern I2C RGB; // RGB sensor
extern DigitalOut ledColour;//Colour sensor led


InterruptIn button(PB_2); // Interruption button
DigitalOut myled1(LED1, PullDown);
DigitalOut myled2(LED2, PullDown);
DigitalOut myled3(LED3, PullDown);
DigitalOut myled4(LED4, PullDown);




Thread ThreadI2c(osPriorityNormal, 512); //I2c thread
Thread ThreadAnalog(osPriorityNormal, 512); //Analog readings thread



Ticker t;// This ticker calls the printing methods in the main thread
bool normal=false; //True while in normal mode
int iteration=0;// Number of iteration (from 0 to 500 in TEST mode; from 0 to 119 in NORMAL mode)
int analog_timer=2000; // Timer of the analog thread (Starts in 2s: TEST mode) 
int I2c_timer=2000; // Timer of the I2c thread
bool readData =  false; // set to true when ticker t
bool hour_past = false; // set to true when normal==1 & iteration==120 (an hour has past)
extern uint8_t dominant_color[]; //Array that keeps count of how many times each color was dominant in the reading

void read_data(void) // Ticker method
{
    readData =  true;
    if(iteration == 4){
        if(normal==true){
        hour_past = true; //An hour has past
        }
     }
}
//Interrupt method. Changes between TEST & NORMAL modes
void switch_mode(){
 if(normal==true){
     t.attach(&read_data, 2.0);
     analog_timer=2000;
     I2c_timer=2000;
     //Cleans the array so there are no old readings from previous NORMAL mode sessions
     dominant_color[0]=0;
     dominant_color[1]=0;
     dominant_color[2]=0;
     }
 else{
     //Changes the timing of operations
     t.attach(&read_data,2);
     analog_timer=2000;
     I2c_timer=2000;
     ledR=1;
     ledB=1;
     ledG=1;
     }
 iteration=0; //resets iteration
 myled1=!myled1;
 myled2=!myled2;   
 normal = !normal;   
 }


extern int clear_value, green_value, red_value, blue_value; //Colour sensor values
extern float temp_value, hum_value; //AnalogIn values in % 
extern float x,y,z;//Accelerometer values (X, Y and Z)

extern float soil;//Soil moisture
extern float light;//Light intensity
extern char getMax(int r, int g, int b);//Method to get the colour of most intensity
char c;//Latest GPS character received
char colour_max; //Colour of most intensity

extern void analogThread();//Method of the analog thread
extern void I2cThread();//Method of the I2c thread
extern void gpsParse();//Parse and print the GPS values
extern void accMinMax(float a,float b, float c);//Keeps track of the minimum and maximum values of each axis of the accelerometer
extern void printAccMinMax();//Prints accelerometer maximum and minumim of each axis
extern void setLedColour();//Sets the colour of the RGB led to the dominant color of the latest reading
extern void addDominantColor();//Keeps track of how many times every colour is dominant
extern void dominantColor();//Checks the dominant (or dominants, in case of a tie) colour and prints it
extern void thresshold();//Checks if the received values exceed any thresshold and sets the corresponding RGB led colour light.

          
//Prints analog reading values          
void printAnalog(){
pc.printf("Soil Moisture: %.0f %% \n\rLight: %f %%\n\r", soil, light );
}
//Prints RGB sensor values
 void printRGB(){
// Print RGB sensor readings
pc.printf("Clear (%d), Red (%d), Green (%d), Blue (%d)\n\r", clear_value, red_value, green_value, blue_value);
}
 //Prints temperature and humidity values
   void printTempHum(){
       //print TemHum readings
       pc.printf("Temperature: %.0f C \n\rHumidity: %.0f %%\n\r", temp_value, hum_value);
    }
    //Prints accelerometer values
    void printAcc(){
        pc.printf("AccX = %f    AccY = %f    AccZ = %f\n\r", x, y, z);
        }
   
int main()
{       
    button.rise(switch_mode);
    //Objects of Data Class
    Datas hum ("Humidity"); 
    Datas temp ("Temperature"); 
    Datas light_v("Light");
    Datas soil_m ("Soil Moisture");
    //Starts in TEST mode; Turn on LED1; Timer = 2s
    myled1=1;
    myled2=0;
    myled3=0;
    myled4=0;
    
    t.attach(&read_data, 2);
    ThreadI2c.start(I2cThread);
    ThreadAnalog.start(analogThread);
  
  //Sets up the GPS
   Adafruit_GPS myGPS(&gps);
   myGPS.begin(9600);

   myGPS.sendCommand("$PMTK314,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n"); // GGCA and RMC messages ONLY 
   wait(0.2); 
   myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ); //Set update rate
    wait(0.2); 
   //myGPS.sendCommand(PMKT_SET_BAUD_115200); 
    wait(0.2); 
   myGPS.sendCommand(PGCMD_NOANTENNA); //Toggle GTOP antenna messages
        
        
    // Initialize color sensor

    // Timing register address 0x01 (0000 0001). We set 1st bit to 1 -> 1000 0001
    char timing_register[2] = {0x81,0x50}; //0x50 ~ 400ms
    RGB.write(RGB_ADDR,timing_register,2,false);

    // Control register address 0x0F (0000 1111). We set 1st bit to 1 -> 1000 1111
    char control_register[2] = {0x8F,0}; //{0x8F, 0x00}, {1000 1111, 0000 0000} -> 1x gain
    RGB.write(RGB_ADDR,control_register,2,false);

    // Enable register address 0x00 (0000 0000). We set 1st bit to 1 -> 1000 0000
    char enable_register[2] = {0x80,0x03}; //{0x80, 0x03}, {1000 0000, 0000 0011} -> AEN = PON = 1
    RGB.write(RGB_ADDR,enable_register,2,false);
    
    while(1){
       if (hour_past){ //An hour has past. Corresponding values are sent to the PC
           hour_past=false;
           hum.normalizeMinMaxAvg(iteration);
           temp.normalizeMinMaxAvg(iteration);
           soil_m.normalizeMinMaxAvg(iteration);
           light_v.normalizeMinMaxAvg(iteration);
           dominantColor();
           printAccMinMax();
          pc.printf("\n\r\n\rHOURLY SUMMARY\n\r\n\r");
          iteration=0;
          
     }      
           
           
           
           
      if (readData){
                 
        //Obtains which one is the greatest - red, green or blue
           colour_max = getMax(red_value, green_value, blue_value);
          pc.printf("Measure # %i\n\r", iteration);
           
          //NORMAL MODE 
                 if(normal){ 
                     pc.printf("NORMAL MODE\n\r");
                 temp.data_set[iteration]=temp_value;
                 hum.data_set[iteration]=hum_value;
                 soil_m.data_set[iteration]=soil;
                 light_v.data_set[iteration]=light;
                 accMinMax(x,y,z);
                 addDominantColor();
                 thresshold();
                 
          //TEST MODE     
               }
              else{
                     if (iteration==500){
                         iteration=0;
                         }
                     pc.printf("TEST MODE\n\r");
                     
               setLedColour();
                 
      
            }
  
  
     
  
    
//Prints RGB values
  printRGB();
           
//Prints Temp & RH values
  printTempHum();

//Prints Acc values
 printAcc();
 
 //Prints Analog In values
 printAnalog();
 
    
       //check if we recieved a new message from GPS, if so, attempt to parse it,
       if ( myGPS.newNMEAreceived() ) {
           if ( myGPS.parse(myGPS.lastNMEA()) ) {
              //Prints the time in Madrid and other location values if FIX==1
           pc.printf("Time: %d:%d:%d.%u\n\r", myGPS.hour, myGPS.minute, myGPS.seconds, myGPS.milliseconds); 
           pc.printf("Fix: %d\n\r", (int) myGPS.fix);
           pc.printf("Quality: %d\n\r", (int) myGPS.fixquality);
           
           if (myGPS.fix) {
               pc.printf("Location: %5.2f%c, %5.2f%c\n\r", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
               pc.printf("Altitude: %5.2f\n\r", myGPS.altitude);
               pc.printf("Satellites: %d\n\r", myGPS.satellites);
          }    
       }
       }
     

      
 pc.printf("\n\r\n\r");
 readData= false; //resets readData until next "tick"
 iteration++; //increases iteratios
  }
    c = myGPS.read();   //queries the GPS
  
       

       

       
       
}
  
}  


