#include "mbed.h"
#include "Si7021.h"
#include "MMA8451Q.h"
#include "TCS34725.h"

extern Serial pc;
Si7021 sensor(PB_9,PB_8);// Temp sensor 
MMA8451Q acc(PB_9, PB_8, MMA8451_I2C_ADDRESS);// Accelerometer
I2C RGB(PB_9, PB_8); // RGB sensor
DigitalOut ledColour(PB_7); // TCS34725 led
extern int I2c_timer;
extern bool normal;
int clear_value, green_value, red_value, blue_value;
float temp_value, hum_value;
float x,y,z;
extern uint8_t dominant_color[3];//Red, green, blue, and the dominant color over the hour.
char clear_data[2] = {0,0};
char red_data[2] = {0,0};
char green_data[2] = {0,0};
char blue_data[2] = {0,0};
char clear_reg[1] = {0x94}; // {‭1001 0100‬} -> 0x14 and we set 1st bit to 1
char red_reg[1] = {0x96}; // {‭1001 0110‬} -> 0x16 and we set 1st bit to 1
char green_reg[1] = {0x98}; // {‭1001 1000‬} -> 0x18 and we set 1st bit to 1
char blue_reg[1] = {0x9A}; // {‭1001 1010‬} -> 0x1A and we set 1st bit to 1


    
    
  void I2cThread ()
{
        while (true){
        
        pc.printf(" ");
        //Temp&Hum sensor
        sensor.measure();
        hum_value=sensor.get_humidity()/1000;
        temp_value=sensor.get_temperature()/1000;
      
        
      
     //Accelerometer 
     x = acc.getAccX();
     y = acc.getAccY();
     z = acc.getAccZ();
    // pc.printf("x = %f\ty = %f\tz = %f\n\r", x, y, z);
     
     //RGB
     
    // Turn on the led in the sensor
    ledColour = 1;

            //Reads clear value
            RGB.write(RGB_ADDR,clear_reg,1, true);
            RGB.read(RGB_ADDR,clear_data,2, false);

            //We store in clear_value the concatenation of clear_data[1] and clear_data[0], switching the bytes.
            clear_value = ((int)clear_data[1] << 8) | clear_data[0];
             
            //Reads red value
            RGB.write(RGB_ADDR,red_reg,1, true);
            RGB.read(RGB_ADDR,red_data,2, false);

            //We store in red_value the concatenation of red_data[1] and red_data[0]
            red_value = ((int)red_data[1] << 8) | red_data[0];

            //Reads green value
            RGB.write(RGB_ADDR,green_reg,1, true);
            RGB.read(RGB_ADDR,green_data,2, false);

            //We store in green_value the concatenation of green_data[1] and green_data[0]
            green_value = ((int)green_data[1] << 8) | green_data[0];

            //Reads blue value
            RGB.write(RGB_ADDR,blue_reg,1, true);
            RGB.read(RGB_ADDR,blue_data,2, false);

            //We store in blue_value the concatenation of blue_data[1] and blue_data[0]
             blue_value = ((int)blue_data[1] << 8) | blue_data[0];
            
            ledColour = 0;
            Thread::wait(I2c_timer);
                        
            }
            }

