#include "mbed.h"
 
#include "Datas.h"

using namespace std;
extern DigitalOut ledR; 
extern DigitalOut ledG; 
extern DigitalOut ledB;
extern Serial pc;
extern float temp_value, hum_value;
extern int clear_value, green_value, red_value, blue_value;
extern float soil, light;
extern int z;

Datas::Datas(string measure_types){
 measure_type=measure_types;


 int i;
 for (i=0; i<120; i++){
 data_set[i]=0;
 }
 }

//Stores all measured values in order to get the average. Prints minimum, maximum and average over the hour.
void Datas::normalizeMinMaxAvg(int l){      
    float max_data = data_set[0];
    float min_data = data_set[0];
    int count = 0;
    float sum = 0;
    int i;
    float avg_data = 0;

    for (i=0; i < l; i++)
    {
        count++;
        sum += data_set[i];

        if ( data_set[i] > max_data)
        {
            max_data=data_set[i];
        }

        else if (data_set[i] < min_data)
        {
            min_data=data_set[i];
        }
    }
    avg_data = sum/count;
    pc.printf("\n\r%s:\n\r Max:%.1f\t Min:%.1f\t Avg:%.1f\n\r", measure_type, max_data, min_data, avg_data);
} 

 void thresshold(){
     //Turn the colour led back OFF, because the order doesn't state it has to remain ON.
     ledR=1;
     ledG=1;
     ledB=1;
     if ((temp_value<21)||(temp_value>23)){ //Temperature thressholds 0ºC and 45ºC 
     pc.printf ("\n\r TEMPERATURE OUT OF LIMITS \n\r");
     //Led turns red
     ledR=0;
     ledG=1;   
     ledB=1;
     }
     else if ((hum_value<25)||(hum_value>75)){ //Humidity thressholds 25% and 75% 
     pc.printf ("\n\r HUMIDITY OUT OF LIMITS \n\r");
     //Led turns green
     ledR=1;
     ledG=0;   
     ledB=1;
     }
     else if (soil<10){ //Soil Moisture thresshold 10% 
     pc.printf ("\n\r SOIL MOISTURE OUT OF LIMITS \n\r");
     //Led turns blue
     ledR=1;
     ledG=1;   
     ledB=0;
     }
     else if (light<10){ //light thressholds 10% 
     pc.printf ("\n\r LIGHT INTENSITY OUT OF LIMITS \n\r");
     //Led turns yellow
     ledR=0;
     ledG=0;   
     ledB=1;
     }
     else if (z<0.2){ //z-axis thresshold: The plant is almost horizontal (z=0).
     pc.printf ("\n\r ORIENTATION OUT OF LIMITS \n\r"); 
     //Led turns purple
     ledR=0;
     ledG=1;   
     ledB=0;
     }
     else if ((clear_value<100)||(red_value<30)||(green_value<60)||(blue_value<30)){ //Colour thresshold (emphasis on the green)
     pc.printf ("\n\r COLOUR INTENSITY OUT OF LIMITS \n\r");
     //Led turns cyan
     ledR=1;
     ledG=0;   
     ledB=0;
     }
}