#include "initialize.h"

void initializeGsm(){
     SIM_SCGC6 |= SIM_SCGC6_DMAMUX_MASK;
      SIM_SCGC7 |= SIM_SCGC7_DMA_MASK;  
      pc.printf("initializing tregisters...!\r\n");
     // control register mux, enabling uart3 receive        
     DMAMUX_CHCFG0 |= DMAMUX_CHCFG_ENBL_MASK|DMAMUX_CHCFG_SOURCE(8); 
     
     // Enable request signal for channel 0 
     DMA_ERQ = DMA_ERQ_ERQ0_MASK;
     
      // select round-robin arbitration priority
     DMA_CR |= DMA_CR_ERCA_MASK;
     
     //enabled error interrupt for DMA0
     //DMA_EEI = DMA_EEI_EEI0_MASK ;
     //Addres for buffer
     DMA_TCD0_SADDR = (uint32_t) &UART_D_REG(UART3_BASE_PTR);
     DMA_TCD0_DADDR = (uint32_t) buffer;
     // Set an offset for source and destination address
     DMA_TCD0_SOFF = 0x00; 
     DMA_TCD0_DOFF = 0x01; // Destination address offset of 1 byte per transaction
     
     // Set source and destination data transfer size
     DMA_TCD0_ATTR = DMA_ATTR_SSIZE(0) | DMA_ATTR_DSIZE(0);
     
     // Number of bytes to be transfered in each service request of the channel
     DMA_TCD0_NBYTES_MLNO = 0x01;
     // Current major iteration count
    DMA_TCD0_CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(len);
    DMA_TCD0_BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(len);
    // Adjustment value used to restore the source and destiny address to the initial value
    // After reading 'len' number of times, the DMA goes back to the beginning by subtracting len*2 from the address (going back to the original address)
    DMA_TCD0_SLAST = 0;      // Source address adjustment
    DMA_TCD0_DLASTSGA = -len;  // Destination address adjustment     
    // Setup control and status register
    DMA_TCD0_CSR = 0;
       
    // enable interrupt call at end of major loop
    DMA_TCD0_CSR |= DMA_CSR_INTMAJOR_MASK;
    
    //Activate dma trasnfer rx interrupt
    UART_C2_REG(UART3) |= UART_C2_RIE_MASK;
    UART_C5_REG(UART3) |= UART_C5_RDMAS_MASK | UART_C5_ILDMAS_MASK | UART_C5_LBKDDMAS_MASK;
    //activate p fifo   
    UART_PFIFO_REG(UART3) |= UART_PFIFO_RXFE_MASK; //RXFE and buffer size of 1 word
    pc.printf("Initialization done...\n\r");
}   


//debugging purposes, print all registers with its data.
void print_registers() {
    
   
    pc.printf("\n\rDMA REGISTERS\n\r");
    pc.printf("DMA_MUX: 0x%08x\r\n",DMAMUX_CHCFG0);
    pc.printf("SADDR0: 0x%08x\r\n",DMA_TCD0_SADDR);
    pc.printf("DADDR0: 0x%08x\r\n",DMA_TCD0_DADDR);
    pc.printf("CITER0: 0x%08x\r\n",DMA_TCD0_CITER_ELINKNO);
    pc.printf("BITER0: 0x%08x\r\n",DMA_TCD0_BITER_ELINKNO);
    pc.printf("DMA_CR: %08x\r\n", DMA_CR);
    pc.printf("DMA_ES: %08x\r\n", DMA_ES);
    pc.printf("DMA_ERQ: %08x\r\n", DMA_ERQ);
    pc.printf("DMA_EEI: %08x\r\n", DMA_EEI);
    pc.printf("DMA_CEEI: %02x\r\n", DMA_CEEI);
    pc.printf("DMA_SEEI: %02x\r\n", DMA_SEEI);
    pc.printf("DMA_CERQ: %02x\r\n", DMA_CERQ);
    pc.printf("DMA_SERQ: %02x\r\n", DMA_SERQ);
    pc.printf("DMA_CDNE: %02x\r\n", DMA_CDNE);
    pc.printf("DMA_SSRT: %02x\r\n", DMA_SSRT);
    pc.printf("DMA_CERR: %02x\r\n", DMA_CERR);
    pc.printf("DMA_CINT: %02x\r\n", DMA_CINT);
    pc.printf("DMA_INT: %08x\r\n", DMA_INT);
    pc.printf("DMA_ERR: %08x\r\n", DMA_ERR);
    pc.printf("DMA_HRS: %08x\r\n", DMA_HRS);
    pc.printf("DMA_TCD0_DLASTSGA: %08x\r\n",DMA_TCD0_DLASTSGA);
    pc.printf("\n\rUART REGISTERS\n\r");
    pc.printf("UART_BDH_REG: %08x\r\n",UART_BDH_REG(UART3)); 
    pc.printf("UART_C1_REG: %08x\r\n",UART_C1_REG(UART3));
    pc.printf("UART_C2_REG: %08x\r\n",UART_C2_REG(UART3));
    pc.printf("UART_S1_REG: %08x\r\n",UART_S1_REG(UART3));
    pc.printf("UART_s2_REG: %08x\r\n",UART_S2_REG(UART3));    
    pc.printf("UART_C3_REG: %08x\r\n",UART_C3_REG(UART3));
    pc.printf("UART_D_REG: %08x\r\n",UART_D_REG(UART3));
    pc.printf("UART_MA1_REG: %08x\r\n",UART_MA1_REG(UART3));
    pc.printf("UART_MA2_REG: %08x\r\n",UART_MA2_REG(UART3));
    pc.printf("UART_C4_REG: %08x\r\n",UART_C4_REG(UART3));
    pc.printf("UART_C5_REG: %08x\r\n",UART_C5_REG(UART3));
    pc.printf("UART_ED_REG: %08x\r\n",UART_ED_REG(UART3));       
    pc.printf("UART_MODEM_REG: %08x\r\n",UART_MODEM_REG(UART3));
    pc.printf("UART_IR_REG: %08x\r\n",UART_IR_REG(UART3)); 
    pc.printf("UART_PFIFO_REG: %08x\r\n",UART_PFIFO_REG(UART3));
    pc.printf("UART_CFIFO_REG: %08x\r\n",UART_CFIFO_REG(UART3));
    pc.printf("UART_SFIFO_REG: %08x\r\n",UART_SFIFO_REG(UART3)); 
    pc.printf("UART_TWFIFO_REG: %08x\r\n",UART_TWFIFO_REG(UART3));
    pc.printf("UART_TCFIFO_REG: %08x\r\n",UART_TCFIFO_REG(UART3)); 
    pc.printf("UART_RWFIFO_REG: %08x\r\n",UART_RWFIFO_REG(UART3)); 
    pc.printf("UART_RCFIFO_REG: %08x\r\n",UART_RCFIFO_REG(UART3));
  
}