#include "mbed.h"
#include "SDFileSystem.h"
#include "stm32f103c8t6.h"
#include "TextLCD.h"
#include "HX711.h" 

SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd"); // MOSI, MISO, SCK, CS
DigitalOut myled(PC_13);
I2C i2c_lcd(PB_9, PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type 
HX711 scale(PA_6,PA_5,32); //(pinData, pinSCK, gain [128|32|64])
Timer t;

typedef enum {
    S0 = 0, S1, S2, S3
} estados;

estados state  = S0;
int count = 0;

void processa_entrada()
{
    static int g;
    static int b;
    static int a;
    static FILE *fp;
    
    
    switch (state) {
        case S0:
        
            //Initialize LCD
            lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
            lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn
            lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
            lcd.printf("Initialize");
            scale.tare(); 
            wait(0.5);
            
            //Initialize SD
            while(sd.disk_status()){
                lcd.printf("sd.disk_status");
                sd.disk_initialize();
                myled = 0;
                wait(0.5);
                myled = 1;
                wait(0.2);
            }
            lcd.printf("sd.disk_status finished");
            wait(1);
            
            //Initialize txt
            lcd.cls();
            lcd.printf("Opening file");
            wait(1);
            fp = fopen("/sd/DADOS.txt", "w");
            if (fp == NULL) {  // if it can't open the file then print error message
                lcd.cls();
                lcd.printf("cant open the file");
                myled = 0;
            }
            lcd.printf("opened file so can write");
            wait(1); 
            lcd.cls();
            lcd.printf("gravando");
            myled = 0;
            state = S1;
            t.start();
            break;
            
            
        case S1:

            //Pegando valor
            /*lcd.cls();
            lcd.printf("Value =");
            lcd.locate(8,0);
            lcd.cls(); */
            //a = t.read_ms();
            g = scale.getValue();
            //b = t.read_ms();
            fprintf(fp, "%d %i \n", count, g);
            //lcd.printf("%d", g);
            //lcd.locate(6,1);
            //lcd.printf("gravando");
            myled = 1;
            
            count++;
            
            if(t.read_ms()>=10000) {
                state = S2;
                count = 0;
            } 
            
            break;
            
            
        case S2: 
            
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("closing file");
            fclose(fp);  // ensure you close the file after writing
            wait(1);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("done");
            wait(1);
            
            state = S3;
            
            break;
            
            
        case S3:
        
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("off");
            wait(2);
            
            break;
            
            
        default:
            break;
}
}

int main(){
    while(1){
    processa_entrada();    
    }
}
    


