#include "mbed.h"
#include "SDFileSystem.h"
#include "FXOS8700CQ.h"
#include "LSM6DS3.h"

// Connections to SD card holder on K64F (SPI interface)
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
Timer t;
FXOS8700CQ fxos(PTE25,PTE24);
LSM6DS3 LSM6DS3(PTE25,PTE24);
Serial pc(USBTX, USBRX);
Data fxos_acc;
unsigned long int start_time = 0, end_time = 0;
uint16_t adc_value;
AnalogIn pot0(A0), pot1(A1), pot2(A2), pot3(A3);



int main()
{
    LSM6DS3.begin();
    fxos.init();
    double t0, t1;
    pc.baud(115200);  // full-speed!
    pc.printf("#### Example #####\n");
    FILE *fp; // this is our file pointer
    t.start();
    t0 = t.read_us();
    fp = fopen("/sd/Teste1.txt", "wb");
    //read Accel & Gyro
    LSM6DS3.readAccel();
    LSM6DS3.readGyro();
    start_time = t.read_us();
    fxos_acc = fxos.get_values();
    end_time = t.read_us();
    pc.printf("\nPass time: %d\n", end_time - start_time);
        //serial send Accel (board)
    pc.printf("BoardAccelerX[%f]\n",fxos_acc.ax);
    pc.printf("BoardAccelerY[%f]\n",fxos_acc.ay);
    pc.printf("BoardAccelerZ[%f]\n",fxos_acc.az);
       //serial send Gyro
    pc.printf("GyroX[%f]\n",LSM6DS3.gx);
    pc.printf("GyroY[%f]\n",LSM6DS3.gy);
    pc.printf("GyroZ[%f]\n",LSM6DS3.gz);
        //serial send Accel (lsm6ds33)
    pc.printf("AccelerX[%f]\n",LSM6DS3.ax);
    pc.printf("AccelerY[%f]\n",LSM6DS3.ay);
    pc.printf("AccelerZ[%f]\n",LSM6DS3.az);
    
    
    if (fp == NULL) {  // if it can't open the file then print error message
                    pc.printf("Error! Unable to open file!\n");
    } else {  // opened file so can write
            fprintf(fp, "%f %f %f \n %f %f %f \n %f %f %f \n", fxos_acc.ax,fxos_acc.ay,fxos_acc.az,LSM6DS3.gx,LSM6DS3.gy,LSM6DS3.gz,LSM6DS3.ax,LSM6DS3.ay,LSM6DS3.az);
            fclose(fp);  // ensure you close the file after writing
            t1 = t.read_us(); 
            pc.printf("The time taken was %lf u-seconds\n", t1-t0);
            t.stop();
    }
}
