#include "mbed.h"
#include "hcsr04.h"
#include "zvucniEfekt.h"
#include "Tipkalo.h"
#include "DeklaracijaVarijabli.h"
#include "IndikatorUdaljenostiObjekta.h"

Tipkalo tipka(gumb);    //deklaracija objekta klase Tipkalo za prekidač te dodjeljivanje pinova s mbeda (PC_13 - gumb se nalazi direktno na tiskanoj pločici)
indikatorUdaljenostiObjekta LED(D2,D3,D4,D5); //deklaracija objekta klase indikatorUdaljenostiObjekta za LED indikatore te dodjeljivanje pinova s mbeda (D2, D3, D4, D5 - NUCLEO F411RE)
HCSR04 senzor_prednji(trigerStraznjegSenzora, echoStraznjegSenzora);  //deklaracija objekta klase HCSR04 za 1.senzor te dodjeljivanje pinova s mbeda (D7,D6 - NUCLEO F411RE)
HCSR04 senzor_zadnji(trigerPrednjegSenzora, echoPrednjegSenzora);     //deklaracija objekta klase HCSR04 za 2.senzor te dodjeljivanje pinova s mbeda (D12,D11 - NUCLEO F411RE)
zvucniEfekt zvucnik(buzzer);                                                 //deklaracija objekta klase Beep za piezo zvučnik te dodjeljivanje pinova s mbeda (D9 (PWM Pin) - NUCLEO F411RE)

//Funkcija koja obavlja svoju zadacu zadanu za straznji senzor sustava
void straznjiSenzor()
{
    int udaljenost_zadnji = senzor_zadnji.udaljenost(); //povlačenje vrijednosti udaljenosti iz klase HCSR04 u definiranu varijablu
    if(udaljenost_zadnji >= 30 && udaljenost_zadnji< 45) {
        LED.udaljenostObjekta30do45();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.3);
        zvucnik.neRadiZvucnik();
        wait(0.8);
    } else if(udaljenost_zadnji>= 15 && udaljenost_zadnji < 30) {
        LED.udaljenostObjekta15do30();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.2);
        zvucnik.neRadiZvucnik();
        wait(0.4);
    } else if(udaljenost_zadnji>=5 && udaljenost_zadnji<15) {
        LED.udaljenostObjekta5do15();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.1);
        zvucnik.neRadiZvucnik();
        wait(0.2);
    } else if(udaljenost_zadnji>=0 && udaljenost_zadnji<5) {
        LED.udaljenostObjekta0do5();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.05);
        zvucnik.neRadiZvucnik();
        wait(0.05);
    } else {
        LED.objektIzvanDometa();
        zvucnik.neRadiZvucnik();
    }
}

//Funkcija koja obavlja svoju zadacu zadanu za prednji senzor sustava
void prednjiSenzor()
{
    long udaljenost_prednji = senzor_prednji.udaljenost();  //povlačenje vrijednosti udaljenosti iz klase HCSR04 u definiranu varijablu
    if(udaljenost_prednji >= 30 && udaljenost_prednji< 45) {
        LED.udaljenostObjekta30do45();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.3);
        zvucnik.neRadiZvucnik();
        wait(0.8);
    } else if(udaljenost_prednji>= 15 && udaljenost_prednji < 30) {
        LED.udaljenostObjekta15do30();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.2);
        zvucnik.neRadiZvucnik();
        wait(0.4);
    } else if(udaljenost_prednji>=5 && udaljenost_prednji<15) {
        LED.udaljenostObjekta5do15();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.1);
        zvucnik.neRadiZvucnik();
        wait(0.2);
    } else if(udaljenost_prednji>=0 && udaljenost_prednji<5) {
        LED.udaljenostObjekta0do5();
        zvucnik.radiZvucnik(500,0.5);
        wait(0.05);
        zvucnik.neRadiZvucnik();
        wait(0.05);
    } else {
        LED.objektIzvanDometa();
        zvucnik.neRadiZvucnik();
    }
}

//Funkcija zaslužna za promjenu rada pojedinog senzora
void prebaciSPrvogNaDrugiSenzor()
{
    if((tipka.procitajBrojPritisakaGumba())%3==0) {  //Postavljen je uvjet o pritisku tipke na mbedu (ako je paran radi prednji senzor a ako je neparan radi straznji senzor)
        straznjiSenzor();  //Poziv funkcije straznjiSenzor()
    } else {
        prednjiSenzor();
    }
}

//glavna funkcija programa
int main()
{
    while(1) {
        prebaciSPrvogNaDrugiSenzor();
    }
}

