/*
 * FreeModbus Libary: BARE Port
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: portserial.c,v 1.1 2006/08/22 21:35:13 wolti Exp $
 */

/* ----------------------- System includes ----------------------------------*/
#include "mbed.h"                   // Cam
#include "RawSerial.h"
/* ----------------------- Platform includes --------------------------------*/
#include "port.h"

/* ----------------------- Modbus includes ----------------------------------*/
#include "mb.h"
#include "mbport.h"

// Dan - Allow serial pins to be configurable in json config
#ifndef MBED_CONF_APP_MODBUS_SERIAL_TX
#define MBED_CONF_APP_MODBUS_SERIAL_TX USBTX
#endif

#ifndef MBED_CONF_APP_MODBUS_SERIAL_RX
#define MBED_CONF_APP_MODBUS_SERIAL_RX USBRX
#endif

/* ----------------------- static functions ---------------------------------*/

static void prvvUARTTxISR( void );
static void prvvUARTRxISR( void );

/* ----------------------- System Variables ---------------------------------*/

static RawSerial* modbus_serial;

/* ----------------------- Start implementation -----------------------------*/

void xMBSetSerial(RawSerial* s){
    modbus_serial = s;
}

void
vMBPortSerialEnable( BOOL xRxEnable, BOOL xTxEnable )
{
    if(xRxEnable){
        modbus_serial->attach(&prvvUARTRxISR, RawSerial::RxIrq); // Dan
    }else{
        modbus_serial->attach(nullptr, RawSerial::RxIrq);
    }

    // if(xTxEnable){
    //     modbus_serial->attach(&prvvUARTTxISR, RawSerial::TxIrq); // Dan
    // }else{
    //     modbus_serial->attach(nullptr, RawSerial::TxIrq);
    // }
}



BOOL
xMBPortSerialInit( UCHAR ucPORT, ULONG ulBaudRate, UCHAR ucDataBits, eMBParity eParity )
{
    SerialBase::Parity p = eParity == MB_PAR_NONE ? SerialBase::None :
        eParity == MB_PAR_EVEN ? SerialBase::Even : SerialBase::Odd;

    modbus_serial->baud(ulBaudRate);
    modbus_serial->format(ucDataBits, p);
    
    return TRUE;
}

BOOL
xMBPortSerialPutByte( CHAR ucByte )
{
    /* Put a byte in the UARTs transmit buffer. This function is called
     * by the protocol stack if pxMBFrameCBTransmitterEmpty( ) has been
     * called. */
    modbus_serial->putc( ucByte);
    return TRUE;
}

BOOL
xMBPortSerialGetByte( CHAR * pucByte )
{
    /* Return the byte in the UARTs receive buffer. This function is called
     * by the protocol stack after pxMBFrameCBByteReceived( ) has been called.
     */
    *pucByte = modbus_serial->getc();
    return TRUE;
}


static void prvvUARTTxISR( void )
{
    pxMBFrameCBTransmitterEmpty(  );
}

/* Create an interrupt handler for the receive interrupt for your target
 * processor. This function should then call pxMBFrameCBByteReceived( ). The
 * protocol stack will then call xMBPortSerialGetByte( ) to retrieve the
 * character.
 */
static void prvvUARTRxISR( void )
{
    pxMBFrameCBByteReceived(  );
}