/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2006 Christian Walter <wolti@sil.at>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * File: $Id: mbtcp.c,v 1.3 2006/12/07 22:10:34 wolti Exp $
 */

/* ----------------------- System includes ----------------------------------*/
#include "stdlib.h"
#include "string.h"

/* ----------------------- Platform includes --------------------------------*/
#include "port.h"

/* ----------------------- Modbus includes ----------------------------------*/
#include "mb.h"
#include "mbconfig.h"
#include "mbrtucustom.h"
#include "mbframe.h"
#include "mbport.h"

#if MB_RTU_CUSTOM_ENABLED == 1

/* ----------------------- Defines ------------------------------------------*/

/* ----------------------- MBAP Header --------------------------------------*/

/* ----------------------- Start implementation -----------------------------*/
eMBErrorCode
eMBRTUCustInit( UCHAR ucMBAddress )
{
    return MB_ENOERR;
}

void
eMBRTUCustStart( void )
{
}

void
eMBRTUCustStop( void )
{
}

eMBErrorCode
eMBRTUCustReceive( UCHAR * pucRcvAddress, UCHAR ** ppucFrame, USHORT * pusLength )
{
    eMBErrorCode    eStatus = MB_EIO;
    UCHAR          *pucMBFrame;
    USHORT          usLength;
    
    ENTER_CRITICAL_SECTION(  );
    if( xMBRTUCustGetPDU( &pucMBFrame, &usLength ) != FALSE )
    {
        //TODO:
        // usMBCRC16( ( UCHAR * ) ucRTUBuf, usRcvBufferPos ) == 0;
        *pucRcvAddress = pucMBFrame[0];
        *ppucFrame = &pucMBFrame[1];
        *pusLength = usLength - 1; // removed address
        eStatus = MB_ENOERR;
    }
    else
    {
        eStatus = MB_EIO;
    }
    EXIT_CRITICAL_SECTION(  );
    return eStatus;
}

eMBErrorCode
eMBRTUCustSend( UCHAR ucSlaveAddress, const UCHAR * pucFrame, USHORT usLength )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    UCHAR           *pucMBFrame;
    
    /* First byte before the Modbus-PDU is the slave address. */
    pucMBFrame = ( UCHAR * ) pucFrame - 1;
    *pucMBFrame = ucSlaveAddress;
    usLength++;

    if( xMBRTUCustSendResponse( pucMBFrame, usLength ) == FALSE )
    {
        eStatus = MB_EIO;
    }
    return eStatus;
}

#endif