#include "mbed.h"

#include "main.h"




Serial command(USBTX, USBRX);

#define MAXDAT 3
#define TIPO_COMM 0
#define NUM_MOTOR 1
#define NUM_GRADOS 2 


uint8_t dat[MAXDAT]={0,0,0};

  

int main() {
    init_servo();
    init_serial();

    debug_m("inicio \n");
    uint32_t read_cc;
    while(1)
    {
        while(read_command()==0);
        switch (dat[TIPO_COMM]) {
            case  0x01: moving(); break;
            default: debug_m("prueba comando. ");
            break ;      
        }
    }
}



uint32_t read_command()
{
   // retorna los byte recibidos concatenados en un entero, 
   

    
    char intc=command.getc();
    
    while(intc != '<')
        intc=command.getc();
        
    for (int i =0;i<MAXDAT;i++)
        dat[i]=command.getc();
    
    intc=command.getc();
    
    if(intc != '>'){
        debug_m("error de comando no se recibe bien  ..\n");    
        return 0;
        }
    return 1;
}


void init_serial()
{
    command.baud(9600);    
}


void moving(){
    debug_m("se inicia el comado mover..\n");    
    
    char nmotor=dat[NUM_MOTOR];
    char grados=dat[NUM_GRADOS];
    mover_ser(nmotor,grados); 
    debug_m("fin del comado ..\n");    
    
}

void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}