#include "mbed.h"
#include "USBCDC_ECM.h"

extern "C"{
#include <stdint.h>
#include "pico_stack.h"
#include "pico_ipv4.h"
}
#include "pico_dev_mbed_usb.h"


USBCDC_ECM usb = USBCDC_ECM(0x0525, 0xa4a1, 1);

int main(void) {
#if 1
    struct pico_device *usb_eth;
    struct pico_ip4 local={.addr = long_be(0x0a280001)};
    struct pico_ip4 netmask={.addr = long_be(0xffffff00)};

    printf("Welcome to the PicoTCP USB demo!\n");
    pico_stack_init();
    
    wait(1);
    printf("Creating device...\n");
    
    usb_eth = pico_mbed_usb_create("usb0", &usb);
    wait(2);
    
    printf("Adding link...\n");
    pico_ipv4_link_add(usb_eth, local, netmask);
    
    printf("Looping!\n");
    while(1){
        wait(0.002);
        pico_stack_tick();
    }
#else
while(1);;
#endif

}
