#include "mbed.h"
#include "EthernetInterface.h"

#define msgdbg(...)

//#define msgdbg printf


#define SENDING_RETRIES    5u
#define READING_RETRIES    5u
#define DHCP_RETRIES       10u
#define BUFFER_SIZE        256

#define NUMBER_OF_HOSTS   3u

#define MBED_HOST               "www.mbed.org"
#define MBED_HOST_REQUEST       "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n"

#define MEDIAFAX_HOST           "www.mediafax.ro"
#define MEDIAFAX_HOST_REQUEST   "GET / HTTP/1.1\nHost: www.mediafax.ro\n\n"

#define NXP_HOST                "www.nxp.com"
#define NXP_HOST_REQUEST        "GET /documents/user_manual/UM10360.pdf HTTP/1.0\nHost: www.nxp.com\n\n"

int totalTime = 0;

struct WebStats
{
    char request[70];
    char host[20];
    int avgDuration;
    int maxReceived;
    int minReceived;
    int snapshots;
};

struct WebStats webStatistics[NUMBER_OF_HOSTS]= 
{
    {MBED_HOST_REQUEST,MBED_HOST,0,0,0x7FFFFFFF,0},
    {MEDIAFAX_HOST_REQUEST,MEDIAFAX_HOST,0,0,0x7FFFFFFF,0},
    {NXP_HOST_REQUEST,NXP_HOST,0,0,0x7FFFFFFF,0}
};

void printStatistics(void)
{
    printf("\nTotal Time : %f seconds\n",(float)totalTime/1000.0f);    
    for(int i=0;i<NUMBER_OF_HOSTS;i++)
    {
        printf("Host number : %d | %s\n",i, webStatistics[i].host);
        printf("MaxRecv : %d\n",webStatistics[i].maxReceived);
        printf("MinRecv : %d\n",webStatistics[i].minReceived);
        printf("Avg duration : %d ms\n",webStatistics[i].avgDuration);
        printf("Total snapshots : %d\n\n",webStatistics[i].snapshots);
    }
    
}

int main() {
    
    int retries = 0;
    EthernetInterface eth;
    TCPSocketConnection client;
    
    printf("Initialising...\n");

    // use DHCP
    eth.init();

    // attempt DHCP and if timing out then try again
    while (eth.connect()) {
        retries++;
        printf("[%d] DHCP timeout %d\n",PICO_TIME_MS(),retries);
        if(retries >= DHCP_RETRIES)
        {
            printf("DHCP failed. Bailing out..\n");
            goto failure;
        }
    };
    
    printf("[%d] Starting the robustness test...\n",PICO_TIME_MS());
    
    while(1) 
    {
        for(int i=0;i<NUMBER_OF_HOSTS;i++,client.close())
        {
            int retries = 0;
            int received = 0;
            int time = 0;
            char tmpBuffer[BUFFER_SIZE];
            int ret;
            
            printf("Mbed --> %s\n",webStatistics[i].host);
            
            time = PICO_TIME_MS();
            // connecting
            if (client.connect(webStatistics[i].host, 80)) {
                printf("Failed to connect to : %s\n",webStatistics[i].host);
                continue;
            }                    
            
            retries = 0;
            
            // sending request
            while(1)
            {
                if( (ret = client.send_all(webStatistics[i].request,strlen(webStatistics[i].request))) <= 0) 
                {
                    printf("Retry sending no %d, return :%d, error code :%d\n",retries,ret,pico_err);
                    retries++;
                }
                else break;
            
                if(retries == SENDING_RETRIES+1)
                {
                    printf("Failed sending. Bailing out this connection\n");
                    continue;
                }            
            }
            retries = 0;
            
            // start reading
            while(true)
            {
                if( (ret = client.receive(tmpBuffer,sizeof(tmpBuffer))) <= 0) 
                    retries++;
                else
                    received += ret;
                
                if(retries == READING_RETRIES)
                    break;                            
            }
            
            //Snapshot!
            time = PICO_TIME_MS() - time;
            
            if(webStatistics[i].maxReceived < received)
            {
                webStatistics[i].maxReceived = received;
            }
            
            if(webStatistics[i].minReceived > received)
            {
                webStatistics[i].minReceived = received;
            }
            printf("Received : %d bytes\n",received);
            webStatistics[i].avgDuration = ((webStatistics[i].avgDuration *(webStatistics[i].snapshots++) ) + time)/webStatistics[i].snapshots;
            totalTime += time;
        }
        
        printStatistics();
        Thread::wait(500);
    }
    failure:    
    printf("Fatal error. Main thread is inactive\n");
    while(1);
}
