/*
 *
 * PicoTCP Socket interface for mbed.
 * Copyright (C) 2013 TASS Belgium NV
 *
 * Released under GPL v2
 *
 * Other licensing models might apply at the sole discretion of the copyright holders.
 *
 *
 * This software is based on the mbed.org EthernetInterface implementation:
 * Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "Socket/DHCPServer.h"
#include "wrapper.h"
#include "proxy_endpoint.h"

static struct pico_dhcp_server_setting setting = {0};

DHCPServer::DHCPServer() {
}

int DHCPServer::init(const char* ip) {
    return DHCPServer::set_server_ip(ip);
}

int DHCPServer::set_server_ip(const char *ip) {
    return pico_string_to_ipv4(ip, &setting.server_ip.addr);
}

int DHCPServer::set_pool_start(const char * pool_start) {
    return pico_string_to_ipv4(pool_start, &setting.pool_start);
}

int DHCPServer::set_pool_end(const char * pool_end) {
    return pico_string_to_ipv4(pool_end, &setting.pool_end);
}

void DHCPServer::set_lease_time(uint32_t lease_time) {
    setting.lease_time = lease_time;
}

int DHCPServer::start(void) {
    return picotcp_dhcp_server_start(&setting);
}

